/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.group;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.Destination;
import org.apache.activemq.util.IdGenerator;

public class Member
implements Externalizable {
    private String name;
    private String id;
    private String hostname;
    private long timeStamp;
    private long startTime;
    private Destination inBoxDestination;

    public Member() {
    }

    public Member(String name) {
        this.name = name;
        this.hostname = IdGenerator.getHostName();
        this.startTime = System.currentTimeMillis();
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    public String getHostname() {
        return this.hostname;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Destination getInBoxDestination() {
        return this.inBoxDestination;
    }

    void setInBoxDestination(Destination dest) {
        this.inBoxDestination = dest;
    }

    public String toString() {
        return this.name + "[" + this.id + "]@" + this.hostname;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.id = in.readUTF();
        this.hostname = in.readUTF();
        this.startTime = in.readLong();
        this.inBoxDestination = (Destination)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name != null ? this.name : "");
        out.writeUTF(this.id != null ? this.id : "");
        out.writeUTF(this.hostname != null ? this.hostname : "");
        out.writeLong(this.startTime);
        out.writeObject(this.inBoxDestination);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof Member) {
            Member other = (Member)obj;
            result = this.id.equals(other.id);
        }
        return result;
    }

    long getTimeStamp() {
        return this.timeStamp;
    }

    void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }
}

