/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.Service;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.TransportConnection;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTempDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionError;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.NetworkBridgeFilter;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.RemoveInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.filter.DestinationFilter;
import org.apache.activemq.filter.SimpleDestinationFilter;
import org.apache.activemq.network.DemandForwardingBridge;
import org.apache.activemq.network.DemandSubscription;
import org.apache.activemq.network.NetworkBridge;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.network.NetworkBridgeListener;
import org.apache.activemq.transport.DefaultTransportListener;
import org.apache.activemq.transport.FutureResponse;
import org.apache.activemq.transport.ResponseCallback;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportDisposedIOException;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.LongSequenceGenerator;
import org.apache.activemq.util.MarshallingSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DemandForwardingBridgeSupport
implements NetworkBridge {
    private static final Log LOG = LogFactory.getLog(DemandForwardingBridge.class);
    private static final ThreadPoolExecutor ASYNC_TASKS = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "NetworkBridge: " + runnable);
            thread.setDaemon(true);
            return thread;
        }
    });
    protected final Transport localBroker;
    protected final Transport remoteBroker;
    protected final IdGenerator idGenerator = new IdGenerator();
    protected final LongSequenceGenerator consumerIdGenerator = new LongSequenceGenerator();
    protected ConnectionInfo localConnectionInfo;
    protected ConnectionInfo remoteConnectionInfo;
    protected SessionInfo localSessionInfo;
    protected ProducerInfo producerInfo;
    protected String remoteBrokerName = "Unknown";
    protected String localClientId;
    protected ConsumerInfo demandConsumerInfo;
    protected int demandConsumerDispatched;
    protected final AtomicBoolean localBridgeStarted = new AtomicBoolean(false);
    protected final AtomicBoolean remoteBridgeStarted = new AtomicBoolean(false);
    protected boolean disposed;
    protected BrokerId localBrokerId;
    protected ActiveMQDestination[] excludedDestinations;
    protected ActiveMQDestination[] dynamicallyIncludedDestinations;
    protected ActiveMQDestination[] staticallyIncludedDestinations;
    protected ActiveMQDestination[] durableDestinations;
    protected final ConcurrentHashMap<ConsumerId, DemandSubscription> subscriptionMapByLocalId = new ConcurrentHashMap();
    protected final ConcurrentHashMap<ConsumerId, DemandSubscription> subscriptionMapByRemoteId = new ConcurrentHashMap();
    protected final BrokerId[] localBrokerPath = new BrokerId[]{null};
    protected CountDownLatch startedLatch = new CountDownLatch(2);
    protected CountDownLatch localStartedLatch = new CountDownLatch(1);
    protected CountDownLatch remoteBrokerNameKnownLatch = new CountDownLatch(1);
    protected final AtomicBoolean remoteInterupted = new AtomicBoolean(false);
    protected final AtomicBoolean lastConnectSucceeded = new AtomicBoolean(false);
    protected NetworkBridgeConfiguration configuration;
    final AtomicLong enqueueCounter = new AtomicLong();
    final AtomicLong dequeueCounter = new AtomicLong();
    private NetworkBridgeListener networkBridgeListener;
    private boolean createdByDuplex;
    private BrokerInfo localBrokerInfo;
    private BrokerInfo remoteBrokerInfo;
    private AtomicBoolean started = new AtomicBoolean();
    private TransportConnection duplexInitiatingConnection;

    public DemandForwardingBridgeSupport(NetworkBridgeConfiguration configuration, Transport localBroker, Transport remoteBroker) {
        this.configuration = configuration;
        this.localBroker = localBroker;
        this.remoteBroker = remoteBroker;
    }

    public void duplexStart(TransportConnection connection, BrokerInfo localBrokerInfo, BrokerInfo remoteBrokerInfo) throws Exception {
        this.localBrokerInfo = localBrokerInfo;
        this.remoteBrokerInfo = remoteBrokerInfo;
        this.duplexInitiatingConnection = connection;
        this.start();
        this.serviceRemoteCommand(remoteBrokerInfo);
    }

    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            this.localBroker.setTransportListener(new DefaultTransportListener(){

                public void onCommand(Object o) {
                    Command command = (Command)o;
                    DemandForwardingBridgeSupport.this.serviceLocalCommand(command);
                }

                public void onException(IOException error) {
                    DemandForwardingBridgeSupport.this.serviceLocalException(error);
                }
            });
            this.remoteBroker.setTransportListener(new TransportListener(){

                public void onCommand(Object o) {
                    Command command = (Command)o;
                    DemandForwardingBridgeSupport.this.serviceRemoteCommand(command);
                }

                public void onException(IOException error) {
                    DemandForwardingBridgeSupport.this.serviceRemoteException(error);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void transportInterupted() {
                    if (DemandForwardingBridgeSupport.this.remoteInterupted.compareAndSet(false, true)) {
                        LOG.info((Object)("Outbound transport to " + DemandForwardingBridgeSupport.this.remoteBrokerName + " interrupted."));
                        if (DemandForwardingBridgeSupport.this.localBridgeStarted.get()) {
                            DemandForwardingBridgeSupport.this.clearDownSubscriptions();
                            DemandForwardingBridgeSupport demandForwardingBridgeSupport = DemandForwardingBridgeSupport.this;
                            synchronized (demandForwardingBridgeSupport) {
                                try {
                                    DemandForwardingBridgeSupport.this.localBroker.oneway(DemandForwardingBridgeSupport.this.localConnectionInfo.createRemoveCommand());
                                }
                                catch (TransportDisposedIOException td) {
                                    LOG.debug((Object)"local broker is now disposed", (Throwable)td);
                                }
                                catch (IOException e) {
                                    LOG.warn((Object)"Caught exception from local start", (Throwable)e);
                                }
                            }
                        }
                        DemandForwardingBridgeSupport.this.localBridgeStarted.set(false);
                        DemandForwardingBridgeSupport.this.remoteBridgeStarted.set(false);
                        DemandForwardingBridgeSupport.this.startedLatch = new CountDownLatch(2);
                        DemandForwardingBridgeSupport.this.localStartedLatch = new CountDownLatch(1);
                    }
                }

                public void transportResumed() {
                    if (DemandForwardingBridgeSupport.this.remoteInterupted.compareAndSet(true, false)) {
                        if (!DemandForwardingBridgeSupport.this.lastConnectSucceeded.get()) {
                            try {
                                LOG.debug((Object)"Previous connection was never fully established. Sleeping for second to avoid busy loop.");
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        DemandForwardingBridgeSupport.this.lastConnectSucceeded.set(false);
                        try {
                            DemandForwardingBridgeSupport.this.startLocalBridge();
                            DemandForwardingBridgeSupport.this.remoteBridgeStarted.set(true);
                            DemandForwardingBridgeSupport.this.startedLatch.countDown();
                            LOG.info((Object)("Outbound transport to " + DemandForwardingBridgeSupport.this.remoteBrokerName + " resumed"));
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Caught exception  from local start in resume transport", (Throwable)e);
                        }
                    }
                }
            });
            this.localBroker.start();
            this.remoteBroker.start();
            try {
                this.triggerRemoteStartBridge();
            }
            catch (IOException e) {
                LOG.warn((Object)"Caught exception from remote start", (Throwable)e);
            }
            NetworkBridgeListener l = this.networkBridgeListener;
            if (l != null) {
                l.onStart(this);
            }
        }
    }

    protected void triggerLocalStartBridge() throws IOException {
        ASYNC_TASKS.execute(new Runnable(){

            public void run() {
                try {
                    DemandForwardingBridgeSupport.this.startLocalBridge();
                }
                catch (Exception e) {
                    DemandForwardingBridgeSupport.this.serviceLocalException(e);
                }
            }
        });
    }

    protected void triggerRemoteStartBridge() throws IOException {
        ASYNC_TASKS.execute(new Runnable(){

            public void run() {
                try {
                    DemandForwardingBridgeSupport.this.startRemoteBridge();
                }
                catch (Exception e) {
                    DemandForwardingBridgeSupport.this.serviceRemoteException(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startLocalBridge() throws Exception {
        if (this.localBridgeStarted.compareAndSet(false, true)) {
            DemandForwardingBridgeSupport demandForwardingBridgeSupport = this;
            synchronized (demandForwardingBridgeSupport) {
                this.remoteBrokerNameKnownLatch.await();
                this.localConnectionInfo = new ConnectionInfo();
                this.localConnectionInfo.setConnectionId(new ConnectionId(this.idGenerator.generateId()));
                this.localClientId = "NC_" + this.remoteBrokerName + "_inbound" + this.configuration.getBrokerName();
                this.localConnectionInfo.setClientId(this.localClientId);
                this.localConnectionInfo.setUserName(this.configuration.getUserName());
                this.localConnectionInfo.setPassword(this.configuration.getPassword());
                this.localBroker.oneway(this.localConnectionInfo);
                this.localSessionInfo = new SessionInfo(this.localConnectionInfo, 1L);
                this.localBroker.oneway(this.localSessionInfo);
                LOG.info((Object)("Network connection between " + this.localBroker + " and " + this.remoteBroker + "(" + this.remoteBrokerName + ") has been established."));
                this.startedLatch.countDown();
                this.localStartedLatch.countDown();
                this.setupStaticDestinations();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startRemoteBridge() throws Exception {
        if (this.remoteBridgeStarted.compareAndSet(false, true)) {
            DemandForwardingBridgeSupport demandForwardingBridgeSupport = this;
            synchronized (demandForwardingBridgeSupport) {
                if (!this.isCreatedByDuplex()) {
                    BrokerInfo brokerInfo = new BrokerInfo();
                    brokerInfo.setBrokerName(this.configuration.getBrokerName());
                    brokerInfo.setNetworkConnection(true);
                    brokerInfo.setDuplexConnection(this.configuration.isDuplex());
                    Properties props = new Properties();
                    IntrospectionSupport.getProperties(this.configuration, props, null);
                    String str = MarshallingSupport.propertiesToString(props);
                    brokerInfo.setNetworkProperties(str);
                    brokerInfo.setBrokerId(this.localBrokerId);
                    this.remoteBroker.oneway(brokerInfo);
                }
                if (this.remoteConnectionInfo != null) {
                    this.remoteBroker.oneway(this.remoteConnectionInfo.createRemoveCommand());
                }
                this.remoteConnectionInfo = new ConnectionInfo();
                this.remoteConnectionInfo.setConnectionId(new ConnectionId(this.idGenerator.generateId()));
                this.remoteConnectionInfo.setClientId("NC_" + this.configuration.getBrokerName() + "_outbound");
                this.remoteConnectionInfo.setUserName(this.configuration.getUserName());
                this.remoteConnectionInfo.setPassword(this.configuration.getPassword());
                this.remoteBroker.oneway(this.remoteConnectionInfo);
                SessionInfo remoteSessionInfo = new SessionInfo(this.remoteConnectionInfo, 1L);
                this.remoteBroker.oneway(remoteSessionInfo);
                this.producerInfo = new ProducerInfo(remoteSessionInfo, 1L);
                this.producerInfo.setResponseRequired(false);
                this.remoteBroker.oneway(this.producerInfo);
                this.demandConsumerInfo = new ConsumerInfo(remoteSessionInfo, 1L);
                this.demandConsumerInfo.setDispatchAsync(this.configuration.isDispatchAsync());
                String advisoryTopic = "ActiveMQ.Advisory.Consumer." + this.configuration.getDestinationFilter();
                if (this.configuration.isBridgeTempDestinations()) {
                    advisoryTopic = advisoryTopic + "," + AdvisorySupport.TEMP_DESTINATION_COMPOSITE_ADVISORY_TOPIC;
                }
                this.demandConsumerInfo.setDestination(new ActiveMQTopic(advisoryTopic));
                this.demandConsumerInfo.setPrefetchSize(this.configuration.getPrefetchSize());
                this.remoteBroker.oneway(this.demandConsumerInfo);
                this.startedLatch.countDown();
                if (!this.disposed) {
                    this.triggerLocalStartBridge();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        if (this.started.compareAndSet(true, false)) {
            LOG.debug((Object)(" stopping " + this.configuration.getBrokerName() + " bridge to " + this.remoteBrokerName + " is disposed already ? " + this.disposed));
            boolean wasDisposedAlready = this.disposed;
            if (!this.disposed) {
                NetworkBridgeListener l = this.networkBridgeListener;
                if (l != null) {
                    l.onStop(this);
                }
                try {
                    this.disposed = true;
                    this.remoteBridgeStarted.set(false);
                    final CountDownLatch sendShutdown = new CountDownLatch(1);
                    ASYNC_TASKS.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                DemandForwardingBridgeSupport.this.localBroker.oneway(new ShutdownInfo());
                                DemandForwardingBridgeSupport.this.remoteBroker.oneway(new ShutdownInfo());
                            }
                            catch (Throwable e) {
                                LOG.debug((Object)"Caught exception sending shutdown", e);
                            }
                            finally {
                                sendShutdown.countDown();
                            }
                        }
                    });
                    if (!sendShutdown.await(100L, TimeUnit.MILLISECONDS)) {
                        LOG.debug((Object)"Network Could not shutdown in a timely manner");
                    }
                }
                finally {
                    ServiceStopper ss = new ServiceStopper();
                    ss.stop(this.localBroker);
                    ss.stop(this.remoteBroker);
                    this.startedLatch.countDown();
                    this.startedLatch.countDown();
                    this.localStartedLatch.countDown();
                    ss.throwFirstException();
                }
            }
            if (wasDisposedAlready) {
                LOG.debug((Object)(this.configuration.getBrokerName() + " bridge to " + this.remoteBrokerName + " stopped"));
            } else {
                LOG.info((Object)(this.configuration.getBrokerName() + " bridge to " + this.remoteBrokerName + " stopped"));
            }
        }
    }

    public void serviceRemoteException(Throwable error) {
        if (!this.disposed) {
            if (error instanceof SecurityException || error instanceof GeneralSecurityException) {
                LOG.error((Object)("Network connection between " + this.localBroker + " and " + this.remoteBroker + " shutdown due to a remote error: " + error));
            } else {
                LOG.warn((Object)("Network connection between " + this.localBroker + " and " + this.remoteBroker + " shutdown due to a remote error: " + error));
            }
            LOG.debug((Object)("The remote Exception was: " + error), error);
            ASYNC_TASKS.execute(new Runnable(){

                public void run() {
                    ServiceSupport.dispose(DemandForwardingBridgeSupport.this.getControllingService());
                }
            });
            this.fireBridgeFailed();
        }
    }

    protected void serviceRemoteCommand(Command command) {
        block21: {
            if (!this.disposed) {
                try {
                    if (command.isMessageDispatch()) {
                        this.waitStarted();
                        MessageDispatch md = (MessageDispatch)command;
                        this.serviceRemoteConsumerAdvisory(md.getMessage().getDataStructure());
                        ++this.demandConsumerDispatched;
                        if ((double)this.demandConsumerDispatched > (double)this.demandConsumerInfo.getPrefetchSize() * 0.75) {
                            this.remoteBroker.oneway(new MessageAck(md, 2, this.demandConsumerDispatched));
                            this.demandConsumerDispatched = 0;
                        }
                        break block21;
                    }
                    if (command.isBrokerInfo()) {
                        this.lastConnectSucceeded.set(true);
                        this.remoteBrokerInfo = (BrokerInfo)command;
                        this.serviceRemoteBrokerInfo(command);
                        this.localBroker.oneway(command);
                        break block21;
                    }
                    if (command.getClass() == ConnectionError.class) {
                        ConnectionError ce = (ConnectionError)command;
                        this.serviceRemoteException(ce.getException());
                        break block21;
                    }
                    if (this.isDuplex()) {
                        if (command.isMessage()) {
                            ActiveMQMessage message = (ActiveMQMessage)command;
                            if (AdvisorySupport.isConsumerAdvisoryTopic(message.getDestination())) {
                                this.serviceRemoteConsumerAdvisory(message.getDataStructure());
                            } else {
                                this.localBroker.oneway(message);
                            }
                            break block21;
                        }
                        switch (command.getDataStructureType()) {
                            case 3: 
                            case 4: 
                            case 6: {
                                this.localBroker.oneway(command);
                                break;
                            }
                            case 5: {
                                this.localStartedLatch.await();
                                if (this.started.get()) {
                                    if (!this.addConsumerInfo((ConsumerInfo)command) && LOG.isDebugEnabled()) {
                                        LOG.debug((Object)("Ignoring ConsumerInfo: " + command));
                                        break;
                                    }
                                    break block21;
                                }
                                LOG.warn((Object)("Stopping - ignoring ConsumerInfo: " + command));
                                break;
                            }
                            default: {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Ignoring remote command: " + command));
                                    break;
                                }
                                break block21;
                            }
                        }
                        break block21;
                    }
                    switch (command.getDataStructureType()) {
                        case 1: 
                        case 10: 
                        case 11: {
                            break;
                        }
                        default: {
                            LOG.warn((Object)("Unexpected remote command: " + command));
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    this.serviceRemoteException(e);
                }
            }
        }
    }

    private void serviceRemoteConsumerAdvisory(DataStructure data) throws IOException {
        int networkTTL = this.configuration.getNetworkTTL();
        if (data.getClass() == ConsumerInfo.class) {
            ConsumerInfo info = (ConsumerInfo)data;
            BrokerId[] path = info.getBrokerPath();
            if (path != null && path.length >= networkTTL) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.configuration.getBrokerName() + " Ignoring Subscription " + info + " restricted to " + networkTTL + " network hops only"));
                }
                return;
            }
            if (DemandForwardingBridgeSupport.contains(info.getBrokerPath(), this.localBrokerPath[0])) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.configuration.getBrokerName() + " Ignoring sub " + info + " already routed through this broker once"));
                }
                return;
            }
            if (!this.isPermissableDestination(info.getDestination())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.configuration.getBrokerName() + " Ignoring sub " + info + " destination " + info.getDestination() + " is not permiited"));
                }
                return;
            }
            if (this.addConsumerInfo(info)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.configuration.getBrokerName() + " Forwarding sub on " + this.localBroker + " from " + this.remoteBrokerName + " :  " + info));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.configuration.getBrokerName() + " Ignoring sub " + info + " already subscribed to matching destination"));
            }
        } else if (data.getClass() == DestinationInfo.class) {
            DestinationInfo destInfo = (DestinationInfo)data;
            BrokerId[] path = destInfo.getBrokerPath();
            if (path != null && path.length >= networkTTL) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Ignoring Subscription " + destInfo + " restricted to " + networkTTL + " network hops only"));
                }
                return;
            }
            if (DemandForwardingBridgeSupport.contains(destInfo.getBrokerPath(), this.localBrokerPath[0])) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Ignoring sub " + destInfo + " already routed through this broker once"));
                }
                return;
            }
            destInfo.setConnectionId(this.localConnectionInfo.getConnectionId());
            if (destInfo.getDestination() instanceof ActiveMQTempDestination) {
                ActiveMQTempDestination tempDest = (ActiveMQTempDestination)destInfo.getDestination();
                tempDest.setConnectionId(this.localSessionInfo.getSessionId().getConnectionId());
            }
            destInfo.setBrokerPath(this.appendToBrokerPath(destInfo.getBrokerPath(), this.getRemoteBrokerPath()));
            LOG.debug((Object)("Replying destination control command: " + destInfo));
            this.localBroker.oneway(destInfo);
        } else if (data.getClass() == RemoveInfo.class) {
            ConsumerId id = (ConsumerId)((RemoveInfo)data).getObjectId();
            this.removeDemandSubscription(id);
        }
    }

    public void serviceLocalException(Throwable error) {
        if (!this.disposed) {
            LOG.info((Object)("Network connection between " + this.localBroker + " and " + this.remoteBroker + " shutdown due to a local error: " + error));
            LOG.debug((Object)("The local Exception was:" + error), error);
            ASYNC_TASKS.execute(new Runnable(){

                public void run() {
                    ServiceSupport.dispose(DemandForwardingBridgeSupport.this.getControllingService());
                }
            });
            this.fireBridgeFailed();
        }
    }

    protected Service getControllingService() {
        return this.duplexInitiatingConnection != null ? this.duplexInitiatingConnection : this;
    }

    protected void addSubscription(DemandSubscription sub) throws IOException {
        if (sub != null) {
            this.localBroker.oneway(sub.getLocalInfo());
        }
    }

    protected void removeSubscription(DemandSubscription sub) throws IOException {
        if (sub != null) {
            this.subscriptionMapByLocalId.remove(sub.getLocalInfo().getConsumerId());
            this.localBroker.oneway(sub.getLocalInfo().createRemoveCommand());
        }
    }

    protected DemandSubscription getDemandSubscription(MessageDispatch md) {
        return this.subscriptionMapByLocalId.get(md.getConsumerId());
    }

    protected Message configureMessage(MessageDispatch md) {
        Message message = md.getMessage().copy();
        message.setBrokerPath(this.appendToBrokerPath(message.getBrokerPath(), this.localBrokerPath));
        message.setProducerId(this.producerInfo.getProducerId());
        message.setDestination(md.getDestination());
        if (message.getOriginalTransactionId() == null) {
            message.setOriginalTransactionId(message.getTransactionId());
        }
        message.setTransactionId(null);
        return message;
    }

    protected void serviceLocalCommand(Command command) {
        if (!this.disposed) {
            boolean trace = LOG.isTraceEnabled();
            try {
                if (command.isMessageDispatch()) {
                    this.enqueueCounter.incrementAndGet();
                    final MessageDispatch md = (MessageDispatch)command;
                    DemandSubscription sub = this.subscriptionMapByLocalId.get(md.getConsumerId());
                    if (sub != null && md.getMessage() != null) {
                        boolean cameFromRemote = false;
                        DataStructure consumerInfo = md.getMessage().getDataStructure();
                        if (consumerInfo != null && consumerInfo instanceof ConsumerInfo) {
                            cameFromRemote = DemandForwardingBridgeSupport.contains(((ConsumerInfo)consumerInfo).getBrokerPath(), this.remoteBrokerInfo.getBrokerId());
                        }
                        Message message = this.configureMessage(md);
                        if (trace) {
                            LOG.trace((Object)("bridging " + this.configuration.getBrokerName() + " -> " + this.remoteBrokerName + ": " + message));
                            LOG.trace((Object)("cameFromRemote = " + cameFromRemote));
                        }
                        if (!message.isResponseRequired() || this.isDuplex()) {
                            if (!cameFromRemote) {
                                this.remoteBroker.oneway(message);
                            } else {
                                LOG.info((Object)"Message not forwarded on to remote, because message came from remote");
                            }
                            this.localBroker.oneway(new MessageAck(md, 2, 1));
                            this.dequeueCounter.incrementAndGet();
                        } else {
                            ResponseCallback callback = new ResponseCallback(){

                                public void onCompletion(FutureResponse future) {
                                    try {
                                        Response response = future.getResult();
                                        if (response.isException()) {
                                            ExceptionResponse er = (ExceptionResponse)response;
                                            DemandForwardingBridgeSupport.this.serviceLocalException(er.getException());
                                        } else {
                                            DemandForwardingBridgeSupport.this.localBroker.oneway(new MessageAck(md, 2, 1));
                                            DemandForwardingBridgeSupport.this.dequeueCounter.incrementAndGet();
                                        }
                                    }
                                    catch (IOException e) {
                                        DemandForwardingBridgeSupport.this.serviceLocalException(e);
                                    }
                                }
                            };
                            this.remoteBroker.asyncRequest(message, callback);
                        }
                    } else if (trace) {
                        LOG.trace((Object)("No subscription registered with this network bridge for consumerId " + md.getConsumerId() + " for message: " + md.getMessage()));
                    }
                } else if (command.isBrokerInfo()) {
                    this.localBrokerInfo = (BrokerInfo)command;
                    this.serviceLocalBrokerInfo(command);
                } else if (command.isShutdownInfo()) {
                    LOG.info((Object)(this.configuration.getBrokerName() + " Shutting down"));
                    if (!this.remoteInterupted.get()) {
                        this.stop();
                    }
                } else if (command.getClass() == ConnectionError.class) {
                    ConnectionError ce = (ConnectionError)command;
                    this.serviceLocalException(ce.getException());
                } else {
                    switch (command.getDataStructureType()) {
                        case 1: {
                            break;
                        }
                        default: {
                            LOG.warn((Object)("Unexpected local command: " + command));
                        }
                    }
                }
            }
            catch (Throwable e) {
                LOG.warn((Object)"Caught an exception processing local command", e);
                this.serviceLocalException(e);
            }
        }
    }

    public ActiveMQDestination[] getDynamicallyIncludedDestinations() {
        return this.dynamicallyIncludedDestinations;
    }

    public void setDynamicallyIncludedDestinations(ActiveMQDestination[] dynamicallyIncludedDestinations) {
        this.dynamicallyIncludedDestinations = dynamicallyIncludedDestinations;
    }

    public ActiveMQDestination[] getExcludedDestinations() {
        return this.excludedDestinations;
    }

    public void setExcludedDestinations(ActiveMQDestination[] excludedDestinations) {
        this.excludedDestinations = excludedDestinations;
    }

    public ActiveMQDestination[] getStaticallyIncludedDestinations() {
        return this.staticallyIncludedDestinations;
    }

    public void setStaticallyIncludedDestinations(ActiveMQDestination[] staticallyIncludedDestinations) {
        this.staticallyIncludedDestinations = staticallyIncludedDestinations;
    }

    public ActiveMQDestination[] getDurableDestinations() {
        return this.durableDestinations;
    }

    public void setDurableDestinations(ActiveMQDestination[] durableDestinations) {
        this.durableDestinations = durableDestinations;
    }

    public Transport getLocalBroker() {
        return this.localBroker;
    }

    public Transport getRemoteBroker() {
        return this.remoteBroker;
    }

    public boolean isCreatedByDuplex() {
        return this.createdByDuplex;
    }

    public void setCreatedByDuplex(boolean createdByDuplex) {
        this.createdByDuplex = createdByDuplex;
    }

    public static boolean contains(BrokerId[] brokerPath, BrokerId brokerId) {
        if (brokerPath != null) {
            for (int i = 0; i < brokerPath.length; ++i) {
                if (!brokerId.equals(brokerPath[i])) continue;
                return true;
            }
        }
        return false;
    }

    protected BrokerId[] appendToBrokerPath(BrokerId[] brokerPath, BrokerId[] pathsToAppend) {
        if (brokerPath == null || brokerPath.length == 0) {
            return pathsToAppend;
        }
        BrokerId[] rc = new BrokerId[brokerPath.length + pathsToAppend.length];
        System.arraycopy(brokerPath, 0, rc, 0, brokerPath.length);
        System.arraycopy(pathsToAppend, 0, rc, brokerPath.length, pathsToAppend.length);
        return rc;
    }

    protected BrokerId[] appendToBrokerPath(BrokerId[] brokerPath, BrokerId idToAppend) {
        if (brokerPath == null || brokerPath.length == 0) {
            return new BrokerId[]{idToAppend};
        }
        BrokerId[] rc = new BrokerId[brokerPath.length + 1];
        System.arraycopy(brokerPath, 0, rc, 0, brokerPath.length);
        rc[brokerPath.length] = idToAppend;
        return rc;
    }

    protected boolean isPermissableDestination(ActiveMQDestination destination) {
        DestinationFilter newFilter;
        ActiveMQDestination match;
        int i;
        if (destination.isTemporary() && !this.configuration.isBridgeTempDestinations()) {
            return false;
        }
        DestinationFilter filter = DestinationFilter.parseFilter(destination);
        ActiveMQDestination[] dests = this.excludedDestinations;
        if (dests != null && dests.length > 0) {
            for (i = 0; i < dests.length; ++i) {
                match = dests[i];
                if (filter instanceof SimpleDestinationFilter && !((newFilter = DestinationFilter.parseFilter(match)) instanceof SimpleDestinationFilter)) {
                    filter = newFilter;
                    match = destination;
                }
                if (match == null || !filter.matches(match)) continue;
                return false;
            }
        }
        if ((dests = this.dynamicallyIncludedDestinations) != null && dests.length > 0) {
            for (i = 0; i < dests.length; ++i) {
                match = dests[i];
                if (filter instanceof SimpleDestinationFilter && !((newFilter = DestinationFilter.parseFilter(match)) instanceof SimpleDestinationFilter)) {
                    filter = newFilter;
                    match = destination;
                }
                if (match == null || !filter.matches(match)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected void setupStaticDestinations() {
        ActiveMQDestination[] dests = this.staticallyIncludedDestinations;
        if (dests != null) {
            for (int i = 0; i < dests.length; ++i) {
                ActiveMQDestination dest = dests[i];
                DemandSubscription sub = this.createDemandSubscription(dest);
                try {
                    this.addSubscription(sub);
                }
                catch (IOException e) {
                    LOG.error((Object)("Failed to add static destination " + dest), (Throwable)e);
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Forwarding messages for static destination: " + dest));
            }
        }
    }

    protected boolean addConsumerInfo(ConsumerInfo consumerInfo) throws IOException {
        boolean result = false;
        ConsumerInfo info = consumerInfo.copy();
        this.addRemoteBrokerToBrokerPath(info);
        DemandSubscription sub = this.createDemandSubscription(info);
        if (sub != null) {
            this.addSubscription(sub);
            result = true;
        }
        return result;
    }

    protected DemandSubscription createDemandSubscription(ConsumerInfo info) throws IOException {
        info.addNetworkConsumerId(info.getConsumerId());
        return this.doCreateDemandSubscription(info);
    }

    protected DemandSubscription doCreateDemandSubscription(ConsumerInfo info) throws IOException {
        DemandSubscription result = new DemandSubscription(info);
        result.getLocalInfo().setConsumerId(new ConsumerId(this.localSessionInfo.getSessionId(), this.consumerIdGenerator.getNextSequenceId()));
        if (info.getDestination().isTemporary()) {
            ActiveMQTempDestination dest = (ActiveMQTempDestination)result.getLocalInfo().getDestination();
            dest.setConnectionId(this.localConnectionInfo.getConnectionId().toString());
        }
        if (this.configuration.isDecreaseNetworkConsumerPriority()) {
            byte priority = -5;
            if (priority > -128 && info.getBrokerPath() != null && info.getBrokerPath().length > 1) {
                priority = (byte)(priority - (info.getBrokerPath().length + 1));
            }
            result.getLocalInfo().setPriority(priority);
        }
        this.configureDemandSubscription(info, result);
        return result;
    }

    protected final DemandSubscription createDemandSubscription(ActiveMQDestination destination) {
        ConsumerInfo info = new ConsumerInfo();
        info.setDestination(destination);
        info.setConsumerId(new ConsumerId(this.localSessionInfo.getSessionId(), this.consumerIdGenerator.getNextSequenceId()));
        DemandSubscription result = null;
        try {
            result = this.createDemandSubscription(info);
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to create DemandSubscription ", (Throwable)e);
        }
        if (result != null) {
            result.getLocalInfo().setPriority((byte)-5);
        }
        return result;
    }

    protected void configureDemandSubscription(ConsumerInfo info, DemandSubscription sub) throws IOException {
        sub.getLocalInfo().setDispatchAsync(this.configuration.isDispatchAsync());
        sub.getLocalInfo().setPrefetchSize(this.configuration.getPrefetchSize());
        this.subscriptionMapByLocalId.put(sub.getLocalInfo().getConsumerId(), sub);
        this.subscriptionMapByRemoteId.put(sub.getRemoteInfo().getConsumerId(), sub);
        sub.getLocalInfo().setAdditionalPredicate(this.createNetworkBridgeFilter(info));
    }

    protected void removeDemandSubscription(ConsumerId id) throws IOException {
        DemandSubscription sub = this.subscriptionMapByRemoteId.remove(id);
        if (sub != null) {
            this.removeSubscription(sub);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("removing sub on " + this.localBroker + " from " + this.remoteBrokerName + " :  " + sub.getRemoteInfo()));
            }
        }
    }

    protected void waitStarted() throws InterruptedException {
        this.startedLatch.await();
    }

    protected void clearDownSubscriptions() {
        this.subscriptionMapByLocalId.clear();
        this.subscriptionMapByRemoteId.clear();
    }

    protected abstract NetworkBridgeFilter createNetworkBridgeFilter(ConsumerInfo var1) throws IOException;

    protected abstract void serviceLocalBrokerInfo(Command var1) throws InterruptedException;

    protected abstract void addRemoteBrokerToBrokerPath(ConsumerInfo var1) throws IOException;

    protected abstract void serviceRemoteBrokerInfo(Command var1) throws IOException;

    protected abstract BrokerId[] getRemoteBrokerPath();

    public void setNetworkBridgeListener(NetworkBridgeListener listener) {
        this.networkBridgeListener = listener;
    }

    private void fireBridgeFailed() {
        NetworkBridgeListener l = this.networkBridgeListener;
        if (l != null) {
            l.bridgeFailed();
        }
    }

    public String getRemoteAddress() {
        return this.remoteBroker.getRemoteAddress();
    }

    public String getLocalAddress() {
        return this.localBroker.getRemoteAddress();
    }

    public String getRemoteBrokerName() {
        return this.remoteBrokerInfo == null ? null : this.remoteBrokerInfo.getBrokerName();
    }

    public String getLocalBrokerName() {
        return this.localBrokerInfo == null ? null : this.localBrokerInfo.getBrokerName();
    }

    public long getDequeueCounter() {
        return this.dequeueCounter.get();
    }

    public long getEnqueueCounter() {
        return this.enqueueCounter.get();
    }

    protected boolean isDuplex() {
        return this.configuration.isDuplex() || this.createdByDuplex;
    }
}

