/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.amq;

import java.io.File;
import org.apache.activemq.kaha.impl.index.hash.HashIndex;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.PersistenceAdapterFactory;
import org.apache.activemq.store.ReferenceStoreAdapter;
import org.apache.activemq.store.amq.AMQPersistenceAdapter;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.util.IOHelper;

public class AMQPersistenceAdapterFactory
implements PersistenceAdapterFactory {
    static final int DEFAULT_MAX_REFERNCE_FILE_LENGTH = 0x200000;
    private TaskRunnerFactory taskRunnerFactory;
    private File dataDirectory;
    private int journalThreadPriority = 10;
    private String brokerName = "localhost";
    private ReferenceStoreAdapter referenceStoreAdapter;
    private boolean syncOnWrite;
    private boolean syncOnTransaction = true;
    private boolean persistentIndex = true;
    private boolean useNio = true;
    private int maxFileLength = 0x2000000;
    private long cleanupInterval = 30000L;
    private int indexBinSize = HashIndex.DEFAULT_BIN_SIZE;
    private int indexKeySize = HashIndex.DEFAULT_KEY_SIZE;
    private int indexPageSize = HashIndex.DEFAULT_PAGE_SIZE;
    private int indexMaxBinSize = HashIndex.MAXIMUM_CAPACITY;
    private int indexLoadFactor = HashIndex.DEFAULT_LOAD_FACTOR;
    private int maxReferenceFileLength = 0x200000;

    public PersistenceAdapter createPersistenceAdapter() {
        AMQPersistenceAdapter result = new AMQPersistenceAdapter();
        result.setDirectory(this.getDataDirectory());
        result.setTaskRunnerFactory(this.getTaskRunnerFactory());
        result.setBrokerName(this.getBrokerName());
        result.setSyncOnWrite(this.isSyncOnWrite());
        result.setPersistentIndex(this.isPersistentIndex());
        result.setReferenceStoreAdapter(this.getReferenceStoreAdapter());
        result.setUseNio(this.isUseNio());
        result.setMaxFileLength(this.getMaxFileLength());
        result.setCleanupInterval(this.getCleanupInterval());
        result.setIndexBinSize(this.getIndexBinSize());
        result.setIndexKeySize(this.getIndexKeySize());
        result.setIndexPageSize(this.getIndexPageSize());
        result.setIndexMaxBinSize(this.getIndexMaxBinSize());
        result.setIndexLoadFactor(this.getIndexLoadFactor());
        result.setMaxReferenceFileLength(this.getMaxReferenceFileLength());
        return result;
    }

    public long getCleanupInterval() {
        return this.cleanupInterval;
    }

    public void setCleanupInterval(long val) {
        this.cleanupInterval = val;
    }

    public File getDataDirectory() {
        if (this.dataDirectory == null) {
            this.dataDirectory = new File(IOHelper.getDefaultDataDirectory(), IOHelper.toFileSystemSafeName(this.brokerName));
        }
        return this.dataDirectory;
    }

    public void setDataDirectory(File dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public TaskRunnerFactory getTaskRunnerFactory() {
        if (this.taskRunnerFactory == null) {
            this.taskRunnerFactory = new TaskRunnerFactory("AMQPersistenceAdaptor Task", this.journalThreadPriority, true, 1000);
        }
        return this.taskRunnerFactory;
    }

    public void setTaskRunnerFactory(TaskRunnerFactory taskRunnerFactory) {
        this.taskRunnerFactory = taskRunnerFactory;
    }

    public int getJournalThreadPriority() {
        return this.journalThreadPriority;
    }

    public void setJournalThreadPriority(int journalThreadPriority) {
        this.journalThreadPriority = journalThreadPriority;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public ReferenceStoreAdapter getReferenceStoreAdapter() {
        return this.referenceStoreAdapter;
    }

    public void setReferenceStoreAdapter(ReferenceStoreAdapter referenceStoreAdapter) {
        this.referenceStoreAdapter = referenceStoreAdapter;
    }

    public boolean isPersistentIndex() {
        return this.persistentIndex;
    }

    public void setPersistentIndex(boolean persistentIndex) {
        this.persistentIndex = persistentIndex;
    }

    public boolean isSyncOnWrite() {
        return this.syncOnWrite;
    }

    public void setSyncOnWrite(boolean syncOnWrite) {
        this.syncOnWrite = syncOnWrite;
    }

    public boolean isSyncOnTransaction() {
        return this.syncOnTransaction;
    }

    public void setSyncOnTransaction(boolean syncOnTransaction) {
        this.syncOnTransaction = syncOnTransaction;
    }

    public boolean isUseNio() {
        return this.useNio;
    }

    public void setUseNio(boolean useNio) {
        this.useNio = useNio;
    }

    public int getMaxFileLength() {
        return this.maxFileLength;
    }

    public void setMaxFileLength(int maxFileLength) {
        this.maxFileLength = maxFileLength;
    }

    public int getIndexBinSize() {
        return this.indexBinSize;
    }

    public void setIndexBinSize(int indexBinSize) {
        this.indexBinSize = indexBinSize;
    }

    public int getIndexKeySize() {
        return this.indexKeySize;
    }

    public void setIndexKeySize(int indexKeySize) {
        this.indexKeySize = indexKeySize;
    }

    public int getIndexPageSize() {
        return this.indexPageSize;
    }

    public void setIndexPageSize(int indexPageSize) {
        this.indexPageSize = indexPageSize;
    }

    public int getIndexMaxBinSize() {
        return this.indexMaxBinSize;
    }

    public void setIndexMaxBinSize(int indexMaxBinSize) {
        this.indexMaxBinSize = indexMaxBinSize;
    }

    public int getIndexLoadFactor() {
        return this.indexLoadFactor;
    }

    public void setIndexLoadFactor(int indexLoadFactor) {
        this.indexLoadFactor = indexLoadFactor;
    }

    public int getMaxReferenceFileLength() {
        return this.maxReferenceFileLength;
    }

    public void setMaxReferenceFileLength(int maxReferenceFileLength) {
        this.maxReferenceFileLength = maxReferenceFileLength;
    }
}

