/*
 * Decompiled with CFR 0.152.
 */
package org.jencks.factory;

import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PartitionedPool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.SinglePool;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.FactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolingSupportFactoryBean
implements FactoryBean {
    private PoolingSupport poolingSupport;
    private String partitionStrategy;
    private int poolMaxSize = 10;
    private int poolMinSize = 0;
    private boolean allConnectionsEqual = true;
    private int connectionMaxWaitMilliseconds = 5000;
    private int connectionMaxIdleMinutes = 15;

    public Object getObject() throws Exception {
        if (this.poolingSupport == null) {
            if (this.partitionStrategy == null || "none".equalsIgnoreCase(this.partitionStrategy)) {
                this.poolingSupport = new SinglePool(this.poolMaxSize, this.poolMinSize, this.connectionMaxWaitMilliseconds, this.connectionMaxIdleMinutes, this.allConnectionsEqual, !this.allConnectionsEqual, false);
            } else if ("by-connector-properties".equalsIgnoreCase(this.partitionStrategy)) {
                this.poolingSupport = new PartitionedPool(this.poolMaxSize, this.poolMinSize, this.connectionMaxWaitMilliseconds, this.connectionMaxIdleMinutes, this.allConnectionsEqual, !this.allConnectionsEqual, false, true, false);
            } else if ("by-subject".equalsIgnoreCase(this.partitionStrategy)) {
                this.poolingSupport = new PartitionedPool(this.poolMaxSize, this.poolMinSize, this.connectionMaxWaitMilliseconds, this.connectionMaxIdleMinutes, this.allConnectionsEqual, !this.allConnectionsEqual, false, false, true);
            } else {
                throw new FatalBeanException("Unknown partition strategy " + this.partitionStrategy);
            }
        }
        return this.poolingSupport;
    }

    public Class<?> getObjectType() {
        return PoolingSupport.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public String getPartitionStrategy() {
        return this.partitionStrategy;
    }

    public void setPartitionStrategy(String partitionStrategy) {
        this.partitionStrategy = partitionStrategy;
    }

    public int getPoolMaxSize() {
        return this.poolMaxSize;
    }

    public void setPoolMaxSize(int poolMaxSize) {
        this.poolMaxSize = poolMaxSize;
    }

    public int getPoolMinSize() {
        return this.poolMinSize;
    }

    public void setPoolMinSize(int poolMinSize) {
        this.poolMinSize = poolMinSize;
    }

    public boolean isAllConnectionsEqual() {
        return this.allConnectionsEqual;
    }

    public void setAllConnectionsEqual(boolean allConnectionsEqual) {
        this.allConnectionsEqual = allConnectionsEqual;
    }

    public int getConnectionMaxWaitMilliseconds() {
        return this.connectionMaxWaitMilliseconds;
    }

    public void setConnectionMaxWaitMilliseconds(int connectionMaxWaitMilliseconds) {
        this.connectionMaxWaitMilliseconds = connectionMaxWaitMilliseconds;
    }

    public int getConnectionMaxIdleMinutes() {
        return this.connectionMaxIdleMinutes;
    }

    public void setConnectionMaxIdleMinutes(int connectionMaxIdleMinutes) {
        this.connectionMaxIdleMinutes = connectionMaxIdleMinutes;
    }
}

