/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogConfigurationException;
import org.apache.juli.logging.internal.JuliLogger;
import org.ops4j.pax.logging.DefaultServiceLog;
import org.ops4j.pax.logging.OSGIPaxLoggingManager;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.osgi.framework.BundleContext;

public class LogFactory {
    public static final String FACTORY_PROPERTY = "org.apache.commons.logging.LogFactory";
    public static final String FACTORY_DEFAULT = "org.apache.commons.logging.impl.LogFactoryImpl";
    public static final String FACTORY_PROPERTIES = "commons-logging.properties";
    public static final String HASHTABLE_IMPLEMENTATION_PROPERTY = "org.apache.commons.logging.LogFactory.HashtableImpl";
    private static LogFactory singleton;
    private static PaxLoggingManager m_paxLogging;
    private static WeakHashMap m_loggers;

    private LogFactory() {
    }

    void setLogConfig(Properties p) {
    }

    public Log getInstance(String name) throws LogConfigurationException {
        PaxLogger logger = m_paxLogging == null ? new DefaultServiceLog(null, name) : m_paxLogging.getLogger(name, JuliLogger.JULI_FQCN);
        JuliLogger juliLogger = new JuliLogger(logger);
        m_loggers.put(juliLogger, name);
        return juliLogger;
    }

    public void release() {
        LogFactory.release(null);
    }

    public Object getAttribute(String name) {
        return null;
    }

    public String[] getAttributeNames() {
        return new String[0];
    }

    public void removeAttribute(String name) {
    }

    public void setAttribute(String name, Object value) {
    }

    public Log getInstance(Class clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    public static LogFactory getFactory() throws LogConfigurationException {
        return singleton;
    }

    public static Log getLog(Class clazz) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(clazz);
    }

    public static Log getLog(String name) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(name);
    }

    public static void release(ClassLoader classLoader) {
        m_paxLogging.close();
        m_paxLogging.dispose();
        m_paxLogging = null;
    }

    public static void releaseAll() {
        LogFactory.release(null);
    }

    public static String objectId(Object o) {
        if (o == null) {
            return "null";
        }
        return o.getClass().getName() + "@" + System.identityHashCode(o);
    }

    public static void setBundleContext(BundleContext bundleContext) {
        m_paxLogging = new OSGIPaxLoggingManager(bundleContext);
        Set entrySet = m_loggers.entrySet();
        Iterator iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            JuliLogger logger = (JuliLogger)entry.getKey();
            String name = (String)entry.getValue();
            logger.setPaxLoggingManager(m_paxLogging, name);
        }
        m_paxLogging.open();
    }

    static {
        m_loggers = new WeakHashMap();
        singleton = new LogFactory();
    }
}

