/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.internal;

import org.ops4j.pax.logging.DefaultServiceLog;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingService;
import org.osgi.framework.Bundle;

public class TrackingLogger
implements PaxLogger {
    private PaxLoggingService m_service;
    private String m_category;
    private Bundle m_bundle;
    private PaxLogger m_delegate;
    private String m_fqcn;

    public TrackingLogger(PaxLoggingService service, String category, Bundle bundle, String fqcn) {
        this.m_fqcn = fqcn;
        this.m_category = category;
        this.m_bundle = bundle;
        this.added(service);
    }

    public boolean isTraceEnabled() {
        return this.m_delegate.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.m_delegate.isDebugEnabled();
    }

    public boolean isWarnEnabled() {
        return this.m_delegate.isWarnEnabled();
    }

    public boolean isInfoEnabled() {
        return this.m_delegate.isInfoEnabled();
    }

    public boolean isErrorEnabled() {
        return this.m_delegate.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.m_delegate.isFatalEnabled();
    }

    public void trace(String message, Throwable t) {
        this.m_delegate.trace(message, t);
    }

    public void debug(String message, Throwable t) {
        this.m_delegate.debug(message, t);
    }

    public void inform(String message, Throwable t) {
        this.m_delegate.inform(message, t);
    }

    public void warn(String message, Throwable t) {
        this.m_delegate.warn(message, t);
    }

    public void error(String message, Throwable t) {
        this.m_delegate.error(message, t);
    }

    public void fatal(String message, Throwable t) {
        this.m_delegate.fatal(message, t);
    }

    public int getLogLevel() {
        return this.m_delegate.getLogLevel();
    }

    public String getName() {
        return this.m_delegate.getName();
    }

    public void added(PaxLoggingService service) {
        this.m_service = service;
        this.m_delegate = this.m_service != null ? this.m_service.getLogger(this.m_bundle, this.m_category, this.m_fqcn) : new DefaultServiceLog(this.m_bundle, this.m_category);
    }

    public void removed() {
        this.m_service = null;
        this.m_delegate = new DefaultServiceLog(this.m_bundle, this.m_category);
    }
}

