/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.config;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.osgi.config.OsgiServiceRegistrationListenerAdapter;
import org.springframework.osgi.config.ParserUtils;
import org.springframework.osgi.service.exporter.support.OsgiServiceFactoryBean;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ServiceBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String TARGET_BEAN_NAME_PROP = "targetBeanName";
    private static final String TARGET_PROP = "target";
    private static final String LISTENERS_PROP = "listeners";
    private static final String INTERFACES_PROP = "interfaces";
    private static final String AUTOEXPORT_PROP = "autoExport";
    private static final String CCL_PROP = "contextClassLoader";
    private static final String INTERFACES_ID = "interfaces";
    private static final String INTERFACE = "interface";
    private static final String PROPS_ID = "service-properties";
    private static final String LISTENER = "registration-listener";
    private static final String REF = "ref";
    private static final String AUTOEXPORT = "auto-export";
    private static final String CONTEXT_CLASSLOADER = "context-class-loader";

    ServiceBeanDefinitionParser() {
    }

    protected Class getBeanClass(Element element) {
        return OsgiServiceFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ParserUtils.parseCustomAttributes(element, builder, new ParserUtils.AttributeCallback(){

            public boolean process(Element parent, Attr attribute, BeanDefinitionBuilder bldr) {
                String name = attribute.getLocalName();
                if (ServiceBeanDefinitionParser.INTERFACE.equals(name)) {
                    bldr.addPropertyValue("interfaces", (Object)attribute.getValue());
                    return false;
                }
                if (ServiceBeanDefinitionParser.REF.equals(name)) {
                    return false;
                }
                if (ServiceBeanDefinitionParser.AUTOEXPORT.equals(name)) {
                    String label = attribute.getValue().toUpperCase(Locale.ENGLISH).replace('-', '_');
                    bldr.addPropertyValue(ServiceBeanDefinitionParser.AUTOEXPORT_PROP, (Object)label);
                    return false;
                }
                if (ServiceBeanDefinitionParser.CONTEXT_CLASSLOADER.equals(name)) {
                    String value = attribute.getValue().toUpperCase(Locale.ENGLISH).replace('-', '_');
                    bldr.addPropertyValue(ServiceBeanDefinitionParser.CCL_PROP, (Object)value);
                    return false;
                }
                return true;
            }
        });
        Object target = null;
        if (element.hasAttribute(REF)) {
            target = new RuntimeBeanReference(element.getAttribute(REF));
        }
        NodeList nl = element.getChildNodes();
        ManagedList listeners = new ManagedList();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element subElement = (Element)node;
            String name = subElement.getLocalName();
            if (this.parseInterfaces(element, subElement, parserContext, builder) || this.parseServiceProperties(element, subElement, parserContext, builder)) continue;
            if (LISTENER.equals(name)) {
                listeners.add((Object)this.parseListener(parserContext, subElement, builder));
                continue;
            }
            target = this.parseBeanReference(element, subElement, parserContext, builder);
        }
        if (target instanceof RuntimeBeanReference) {
            builder.addPropertyValue(TARGET_BEAN_NAME_PROP, (Object)target.getBeanName());
        } else {
            builder.addPropertyValue(TARGET_PROP, target);
        }
        builder.addPropertyValue(LISTENERS_PROP, (Object)listeners);
    }

    private boolean parseInterfaces(Element parent, Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String name = element.getLocalName();
        if ("interfaces".equals(name)) {
            if (parent.hasAttribute(INTERFACE)) {
                parserContext.getReaderContext().error("either 'interface' attribute or <intefaces> sub-element has be specified", (Object)parent);
            }
            Set interfaces = parserContext.getDelegate().parseSetElement(element, (BeanDefinition)builder.getBeanDefinition());
            builder.addPropertyValue("interfaces", (Object)interfaces);
            return true;
        }
        return false;
    }

    private boolean parseServiceProperties(Element parent, Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String name = element.getLocalName();
        if (PROPS_ID.equals(name)) {
            if (DomUtils.getChildElementsByTagName((Element)element, (String)"entry").size() > 0) {
                Map props = parserContext.getDelegate().parseMapElement(element, (BeanDefinition)builder.getRawBeanDefinition());
                builder.addPropertyValue(Conventions.attributeNameToPropertyName((String)PROPS_ID), (Object)props);
            } else {
                parserContext.getReaderContext().error("Invalid service property type", (Object)element);
            }
            return true;
        }
        return false;
    }

    private Object parseBeanReference(Element parent, Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        if (parent.hasAttribute(REF)) {
            parserContext.getReaderContext().error("nested bean definition/reference cannot be used when attribute 'ref' is specified", (Object)parent);
        }
        return parserContext.getDelegate().parsePropertySubElement(element, (BeanDefinition)builder.getBeanDefinition());
    }

    private BeanDefinition parseListener(ParserContext context, Element element, BeanDefinitionBuilder builder) {
        NodeList nl = element.getChildNodes();
        Object target = null;
        String targetName = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element nestedDefinition = (Element)node;
            if (element.hasAttribute(REF)) {
                context.getReaderContext().error("nested bean declaration is not allowed if 'ref' attribute has been specified", (Object)nestedDefinition);
            }
            if (!((target = context.getDelegate().parsePropertySubElement(nestedDefinition, (BeanDefinition)builder.getBeanDefinition())) instanceof RuntimeBeanReference)) continue;
            targetName = ((RuntimeBeanReference)target).getBeanName();
        }
        MutablePropertyValues vals = new MutablePropertyValues();
        NamedNodeMap attrs = element.getAttributes();
        for (int x = 0; x < attrs.getLength(); ++x) {
            Attr attribute = (Attr)attrs.item(x);
            String name = attribute.getLocalName();
            if (REF.equals(name)) {
                targetName = attribute.getValue();
                continue;
            }
            vals.addPropertyValue(Conventions.attributeNameToPropertyName((String)name), (Object)attribute.getValue());
        }
        RootBeanDefinition wrapperDef = new RootBeanDefinition(OsgiServiceRegistrationListenerAdapter.class);
        if (targetName != null) {
            vals.addPropertyValue(TARGET_BEAN_NAME_PROP, targetName);
        } else {
            vals.addPropertyValue(TARGET_PROP, target);
        }
        wrapperDef.setPropertyValues(vals);
        return wrapperDef;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }
}

