/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.management;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.Role;
import org.apache.servicemix.nmr.api.Status;
import org.apache.servicemix.nmr.api.event.ExchangeListener;
import org.apache.servicemix.nmr.api.internal.InternalEndpoint;
import org.apache.servicemix.nmr.api.internal.InternalExchange;
import org.apache.servicemix.nmr.management.ManagedEndpoint;
import org.apache.servicemix.nmr.management.ManagementAgent;
import org.apache.servicemix.nmr.management.NamingStrategy;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementEndpointRegistry
implements ExchangeListener,
InitializingBean {
    private static final transient Log LOG = LogFactory.getLog(ManagementEndpointRegistry.class);
    private NamingStrategy namingStrategy;
    private ManagementAgent managementAgent;
    private Map<String, ManagedEndpoint> endpoints = new ConcurrentHashMap<String, ManagedEndpoint>();

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public ManagementAgent getManagementAgent() {
        return this.managementAgent;
    }

    public void setManagementAgent(ManagementAgent managementAgent) {
        this.managementAgent = managementAgent;
    }

    public void register(InternalEndpoint endpoint, Map<String, ?> properties) {
        try {
            LOG.info((Object)("Registering endpoint: " + endpoint + " with properties " + properties));
            ManagedEndpoint ep = new ManagedEndpoint(endpoint, properties);
            this.endpoints.put(endpoint.getId(), ep);
            this.managementAgent.register(ep, this.namingStrategy.getObjectName(ep));
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to register managed endpoint: " + e), (Throwable)e);
        }
    }

    public void unregister(InternalEndpoint endpoint, Map<String, ?> properties) {
        try {
            LOG.info((Object)("Unregistering endpoint: " + endpoint + " with properties " + properties));
            ManagedEndpoint ep = this.endpoints.remove(endpoint.getId());
            this.managementAgent.unregister(this.namingStrategy.getObjectName(ep));
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to unregister managed endpoint: " + e), (Throwable)e);
        }
    }

    public void exchangeSent(Exchange exchange) {
        try {
            LOG.info((Object)("Sending exchange: " + exchange));
            if (exchange.getStatus() == Status.Active && exchange.getRole() == Role.Consumer && exchange.getOut(false) == null && exchange.getFault(false) == null && exchange instanceof InternalExchange) {
                String id = ((InternalExchange)exchange).getSource().getId();
                LOG.info((Object)("Source endpoint: " + id + " (known endpoints: " + this.endpoints + ")"));
                ManagedEndpoint me = this.endpoints.get(id);
                me.incrementOutbound();
            }
        }
        catch (Throwable t) {
            LOG.warn((Object)("Caught exception while processing exchange: " + t), t);
        }
    }

    public void exchangeDelivered(Exchange exchange) {
        try {
            LOG.info((Object)("Receiving exchange: " + exchange));
            if (exchange.getStatus() == Status.Active && exchange.getRole() == Role.Provider && exchange.getOut(false) == null && exchange.getFault(false) == null && exchange instanceof InternalExchange) {
                String id = ((InternalExchange)exchange).getDestination().getId();
                LOG.info((Object)("Dest endpoint: " + id + " (known endpoints: " + this.endpoints + ")"));
                ManagedEndpoint me = this.endpoints.get(id);
                me.incrementInbound();
            }
        }
        catch (Throwable t) {
            LOG.warn((Object)("Caught exception while processing exchange: " + t), t);
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.managementAgent == null) {
            throw new IllegalArgumentException("managementAgent must not be null");
        }
        if (this.namingStrategy == null) {
            throw new IllegalArgumentException("namingStrategy must not be null");
        }
    }
}

