/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell;

import java.io.StringReader;
import org.apache.geronimo.gshell.CommandLine;
import org.apache.geronimo.gshell.CommandLineBuilder;
import org.apache.geronimo.gshell.ErrorNotification;
import org.apache.geronimo.gshell.ExecutingVisitor;
import org.apache.geronimo.gshell.command.CommandExecutor;
import org.apache.geronimo.gshell.logging.LoggingVisitor;
import org.apache.geronimo.gshell.parser.ASTCommandLine;
import org.apache.geronimo.gshell.parser.CommandLineParser;
import org.apache.geronimo.gshell.parser.ParseException;
import org.apache.geronimo.gshell.shell.Environment;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=CommandLineBuilder.class)
public class DefaultCommandLineBuilder
implements CommandLineBuilder {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Requirement
    private PlexusContainer container;
    private CommandLineParser parser = new CommandLineParser();

    public DefaultCommandLineBuilder() {
    }

    public DefaultCommandLineBuilder(PlexusContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ASTCommandLine parse(String input) throws ParseException {
        ASTCommandLine cl;
        assert (input != null);
        StringReader reader = new StringReader(input);
        try {
            cl = this.parser.parse(reader);
        }
        finally {
            IOUtil.close(reader);
        }
        if (this.log.isDebugEnabled()) {
            LoggingVisitor logger = new LoggingVisitor(this.log);
            cl.jjtAccept(logger, null);
        }
        return cl;
    }

    public CommandLine create(String commandLine) throws ParseException {
        assert (commandLine != null);
        if (commandLine.trim().length() == 0) {
            throw new IllegalArgumentException("Command line is empty");
        }
        try {
            CommandExecutor executor = (CommandExecutor)this.container.lookup(CommandExecutor.class);
            Environment env = (Environment)this.container.lookup(Environment.class);
            final ExecutingVisitor visitor = new ExecutingVisitor(executor, env);
            final ASTCommandLine root = this.parse(commandLine);
            return new CommandLine(){

                public Object execute() throws Exception {
                    return root.jjtAccept(visitor, null);
                }
            };
        }
        catch (Exception e) {
            throw new ErrorNotification(e);
        }
    }
}

