/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.concurrent.atomic.AtomicReference;
import jline.History;
import jline.Terminal;
import org.apache.geronimo.gshell.ErrorNotification;
import org.apache.geronimo.gshell.ExitNotification;
import org.apache.geronimo.gshell.ansi.Renderer;
import org.apache.geronimo.gshell.branding.Branding;
import org.apache.geronimo.gshell.command.CommandExecutor;
import org.apache.geronimo.gshell.command.IO;
import org.apache.geronimo.gshell.console.Console;
import org.apache.geronimo.gshell.console.FileHistory;
import org.apache.geronimo.gshell.console.JLineConsole;
import org.apache.geronimo.gshell.console.TerminalInfo;
import org.apache.geronimo.gshell.shell.Environment;
import org.apache.geronimo.gshell.shell.InteractiveShell;
import org.apache.geronimo.gshell.shell.ShellInfo;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=InteractiveShell.class, hint="default")
public class DefaultShell
implements InteractiveShell,
Initializable {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Requirement
    private ShellInfo shellInfo;
    @Requirement
    private Branding branding;
    @Requirement
    private CommandExecutor executor;
    @Requirement
    private TerminalInfo termInfo;
    @Requirement
    private Terminal terminal;
    @Requirement
    private Environment env;
    @Requirement
    private IO io;
    @Requirement
    private History history;
    private Console.Prompter prompter;
    private Console.ErrorHandler errorHandler;

    public DefaultShell() {
    }

    public DefaultShell(ShellInfo shellInfo, Branding branding, CommandExecutor executor, Terminal terminal, Environment env, IO io, History history) {
        this.shellInfo = shellInfo;
        this.branding = branding;
        this.executor = executor;
        this.terminal = terminal;
        this.env = env;
        this.io = io;
        this.history = history;
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public ShellInfo getShellInfo() {
        return this.shellInfo;
    }

    public void initialize() throws InitializationException {
        try {
            this.loadProfileScripts();
        }
        catch (Exception e) {
            throw new InitializationException(e.getMessage(), e);
        }
    }

    public Object execute(String line) throws Exception {
        return this.executor.execute(line);
    }

    public Object execute(Object ... args) throws Exception {
        return this.executor.execute(args);
    }

    public Object execute(String path, Object[] args) throws Exception {
        return this.executor.execute(path, args);
    }

    public Object execute(Object[][] commands) throws Exception {
        return this.executor.execute(commands);
    }

    public void run(Object ... args) throws Exception {
        assert (args != null);
        this.log.debug("Starting interactive console; args: {}", args);
        this.loadUserScript(this.branding.getInteractiveScriptName());
        final AtomicReference exitNotifHolder = new AtomicReference();
        final AtomicReference lastResultHolder = new AtomicReference();
        Console.Executor executor = new Console.Executor(){

            public Console.Executor.Result execute(String line) throws Exception {
                assert (line != null);
                try {
                    Object result = DefaultShell.this.execute(line);
                    lastResultHolder.set(result);
                }
                catch (ExitNotification n) {
                    exitNotifHolder.set(n);
                    return Console.Executor.Result.STOP;
                }
                return Console.Executor.Result.CONTINUE;
            }
        };
        JLineConsole console = new JLineConsole(executor, this.io, this.terminal);
        console.setPrompter(this.getPrompter());
        console.setErrorHandler(this.getErrorHandler());
        if (this.history == null) {
            this.history = new FileHistory(this.branding);
        }
        console.setHistory(this.history);
        if (!this.io.isQuiet()) {
            this.io.out.println(this.branding.getWelcomeBanner());
        }
        if (args.length != 0) {
            this.execute(args);
        }
        console.run();
        ExitNotification n = (ExitNotification)exitNotifHolder.get();
        if (n != null) {
            throw n;
        }
    }

    public Console.Prompter getPrompter() {
        if (this.prompter == null) {
            this.prompter = this.createPrompter();
        }
        return this.prompter;
    }

    public void setPrompter(Console.Prompter prompter) {
        this.prompter = prompter;
    }

    protected Console.Prompter createPrompter() {
        return new Console.Prompter(){
            Renderer renderer = new Renderer();

            public String prompt() {
                String userName = DefaultShell.this.shellInfo.getUserName();
                String hostName = DefaultShell.this.shellInfo.getLocalHost().getHostName();
                String path = "/";
                return this.renderer.render("@|bold " + userName + "|@" + hostName + ":@|bold " + path + "|> ");
            }
        };
    }

    public Console.ErrorHandler getErrorHandler() {
        if (this.errorHandler == null) {
            this.errorHandler = this.createErrorHandler();
        }
        return this.errorHandler;
    }

    public void setErrorHandler(Console.ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Console.ErrorHandler createErrorHandler() {
        return new Console.ErrorHandler(){

            public Console.ErrorHandler.Result handleError(Throwable error) {
                assert (error != null);
                DefaultShell.this.displayError(error);
                return Console.ErrorHandler.Result.CONTINUE;
            }
        };
    }

    private void displayError(Throwable error) {
        assert (error != null);
        Throwable cause = error;
        if (error instanceof ErrorNotification) {
            cause = error.getCause();
        }
        this.io.err.print("@|bold,red ERROR| ");
        this.io.err.print(cause.getClass().getSimpleName());
        this.io.err.println(": @|bold,red " + cause.getMessage() + "|");
        String stackTraceProperty = System.getProperty("gshell.show.stacktrace");
        boolean stackTraceFlag = false;
        if (stackTraceProperty != null) {
            stackTraceFlag = stackTraceProperty.trim().equals("true");
        }
        if (this.io.isDebug()) {
            this.log.debug(error.toString(), error);
        } else if (this.io.isVerbose() || stackTraceFlag) {
            StackTraceElement[] trace = cause.getStackTrace();
            StringBuffer buff = new StringBuffer();
            for (StackTraceElement e : trace) {
                buff.append("        @|bold at| ").append(e.getClassName()).append(".").append(e.getMethodName()).append(" (@|bold ");
                buff.append(e.isNativeMethod() ? "Native Method" : (e.getFileName() != null && e.getLineNumber() != -1 ? e.getFileName() + ":" + e.getLineNumber() : (e.getFileName() != null ? e.getFileName() : "Unknown Source")));
                buff.append("|)");
                this.io.err.println(buff);
                buff.setLength(0);
            }
        }
    }

    private void loadProfileScripts() throws Exception {
        this.loadSharedScript(this.branding.getProfileScriptName());
        this.loadUserScript(this.branding.getProfileScriptName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadScript(File file) throws Exception {
        assert (file != null);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                this.execute(line);
            }
        }
        finally {
            IOUtil.close(reader);
        }
    }

    private void loadUserScript(String fileName) throws Exception {
        assert (fileName != null);
        File file = new File(this.branding.getUserDirectory(), fileName);
        if (file.exists()) {
            this.log.debug("Loading user-script: {}", (Object)file);
            this.loadScript(file);
        } else {
            this.log.debug("User script is not present: {}", (Object)file);
        }
    }

    private void loadSharedScript(String fileName) throws Exception {
        assert (fileName != null);
        File file = new File(this.branding.getSharedDirectory(), fileName);
        if (file.exists()) {
            this.log.debug("Loading shared-script: {}", (Object)file);
            this.loadScript(file);
        } else {
            this.log.debug("Shared script is not present: {}", (Object)file);
        }
    }
}

