/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.geronimo.gshell.branding.Branding;
import org.apache.geronimo.gshell.shell.ShellInfo;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=ShellInfo.class, hint="default")
public class DefaultShellInfo
implements ShellInfo,
Initializable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Requirement
    private Branding branding;
    private InetAddress localHost;
    private File homeDir;

    public DefaultShellInfo() {
    }

    public DefaultShellInfo(Branding branding) {
        this.branding = branding;
    }

    public File getHomeDir() {
        if (this.homeDir == null) {
            throw new IllegalStateException();
        }
        return this.homeDir;
    }

    public InetAddress getLocalHost() {
        if (this.localHost == null) {
            throw new IllegalStateException();
        }
        return this.localHost;
    }

    public String getUserName() {
        return System.getProperty("user.name");
    }

    public void initialize() throws InitializationException {
        this.homeDir = this.detectHomeDir();
        this.log.debug("Using home directory: {}", (Object)this.homeDir);
        try {
            this.localHost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new InitializationException("Unable to determine locahost", e);
        }
    }

    private File detectHomeDir() throws InitializationException {
        File dir;
        String homePath = this.branding.getProperty("home");
        if (homePath == null) {
            homePath = System.getProperty("user.home");
        }
        try {
            dir = new File(homePath).getCanonicalFile();
        }
        catch (IOException e) {
            throw new InitializationException("Failed to resolve home directory: " + homePath, e);
        }
        if (!dir.exists() || !dir.isDirectory()) {
            throw new InitializationException("Home directory configured but is not a valid directory: " + dir);
        }
        return dir;
    }
}

