/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.branding;

import java.io.StringWriter;
import jline.Terminal;
import org.apache.geronimo.gshell.ansi.Buffer;
import org.apache.geronimo.gshell.ansi.RenderWriter;
import org.apache.geronimo.gshell.branding.Branding;
import org.apache.geronimo.gshell.branding.BrandingSupport;
import org.apache.geronimo.gshell.branding.VersionLoader;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.StringUtils;

@Component(role=Branding.class, hint="default")
public class DefaultBranding
extends BrandingSupport {
    @Requirement
    private VersionLoader versionLoader;
    @Requirement
    private Terminal terminal;
    private static final String[] BANNER = new String[]{"                          ,,                 ,,    ,,", "   .g8\"\"\"bgd   .M\"\"\"bgd `7MM               `7MM  `7MM", " .dP'     `M  ,MI    \"Y   MM                 MM    MM", " dM'       `  `MMb.       MMpMMMb.  .gP\"Ya   MM    MM", " MM             `YMMNq.   MM    MM ,M'   Yb  MM    MM", " MM.    `7MMF'.     `MM   MM    MM 8M\"\"\"\"\"\"  MM    MM", " `Mb.     MM  Mb     dM   MM    MM YM.    ,  MM    MM", "   `\"bmmmdPY  P\"Ybmmd\"  .JMML  JMML.`Mbmmd'.JMML..JMML."};

    public DefaultBranding() {
    }

    public DefaultBranding(VersionLoader versionLoader, Terminal terminal) {
        this.versionLoader = versionLoader;
        this.terminal = terminal;
    }

    public String getName() {
        return "gshell";
    }

    public String getDisplayName() {
        return "GShell";
    }

    public String getProgramName() {
        return System.getProperty("program.name", "gsh");
    }

    public String getAbout() {
        StringWriter writer = new StringWriter();
        RenderWriter out = new RenderWriter(writer);
        out.println("For information about @|cyan GShell|, visit:");
        out.println("    @|bold http://geronimo.apache.org/gshell.html| ");
        out.flush();
        return writer.toString();
    }

    public String getVersion() {
        return this.versionLoader.getVersion();
    }

    public String getWelcomeBanner() {
        StringWriter writer = new StringWriter();
        RenderWriter out = new RenderWriter(writer);
        Buffer buff = new Buffer();
        for (String line : BANNER) {
            buff.attrib(line, 36);
            out.println(buff);
        }
        out.println();
        out.println(" @|bold GShell| (" + this.getVersion() + ")");
        out.println();
        out.println("Type '@|bold help|' for more information.");
        int width = this.terminal.getTerminalWidth();
        if (width < 1) {
            width = 80;
        }
        out.print(StringUtils.repeat("-", width - 1));
        out.flush();
        return writer.toString();
    }
}

