/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.branding;

import java.io.StringWriter;
import jline.Terminal;
import org.apache.geronimo.gshell.ansi.Buffer;
import org.apache.geronimo.gshell.ansi.RenderWriter;
import org.apache.geronimo.gshell.branding.BrandingSupport;
import org.apache.geronimo.gshell.branding.VersionLoader;
import org.codehaus.plexus.util.StringUtils;

public class ServiceMixBranding
extends BrandingSupport {
    private static final String[] BANNER = new String[]{" ____                  _          __  __ _       ", "/ ___|  ___ _ ____   _(_) ___ ___|  \\/  (_)_  __", "\\___ \\ / _ \\ '__\\ \\ / / |/ __/ _ \\ |\\/| | \\ \\/ /", " ___) |  __/ |   \\ V /| | (_|  __/ |  | | |>  <", "|____/ \\___|_|    \\_/ |_|\\___\\___|_|  |_|_/_/\\_\\"};
    private VersionLoader versionLoader;
    private Terminal terminal;

    public ServiceMixBranding(VersionLoader versionLoader, Terminal terminal) {
        this.versionLoader = versionLoader;
        this.terminal = terminal;
    }

    public String getName() {
        return "servicemix";
    }

    public String getDisplayName() {
        return "ServiceMix";
    }

    public String getProgramName() {
        return System.getProperty("program.name", "gsh");
    }

    public String getAbout() {
        StringWriter writer = new StringWriter();
        RenderWriter out = new RenderWriter(writer);
        out.println("For information about @|cyan ServiceMix|, visit:");
        out.println("    @|bold http://servicemix.apache.org| ");
        out.flush();
        return writer.toString();
    }

    public String getVersion() {
        return this.versionLoader.getVersion();
    }

    public String getWelcomeBanner() {
        StringWriter writer = new StringWriter();
        RenderWriter out = new RenderWriter(writer);
        Buffer buff = new Buffer();
        for (String line : BANNER) {
            buff.attrib(line, 36);
            out.println(buff);
        }
        out.println();
        out.println(" @|bold ServiceMix| (" + this.getVersion() + ")");
        out.println();
        out.println("Type '@|bold help|' for more information.");
        int width = this.terminal.getTerminalWidth();
        if (width < 1) {
            width = 80;
        }
        out.print(StringUtils.repeat("-", width - 1));
        out.flush();
        return writer.toString();
    }
}

