/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.clp;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.clp.ArgumentDescriptor;
import org.apache.geronimo.gshell.clp.IllegalAnnotationError;
import org.apache.geronimo.gshell.clp.Messages;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.clp.OptionDescriptor;
import org.apache.geronimo.gshell.clp.ProcessingException;
import org.apache.geronimo.gshell.clp.StopProcessingOptionsNotification;
import org.apache.geronimo.gshell.clp.handler.Handler;
import org.apache.geronimo.gshell.clp.handler.Handlers;
import org.apache.geronimo.gshell.clp.handler.Parameters;
import org.apache.geronimo.gshell.clp.setter.CollectionFieldSetter;
import org.apache.geronimo.gshell.clp.setter.FieldSetter;
import org.apache.geronimo.gshell.clp.setter.MethodSetter;
import org.apache.geronimo.gshell.clp.setter.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineProcessor {
    private final Object bean;
    private final List<Handler> optionHandlers = new ArrayList<Handler>();
    private final List<Handler> argumentHandlers = new ArrayList<Handler>();
    private boolean stopAtNonOption = false;

    public CommandLineProcessor(Object bean) throws IllegalAnnotationError {
        assert (bean != null);
        this.bean = bean;
        this.discoverDescriptors();
    }

    public Object getBean() {
        return this.bean;
    }

    public List<Handler> getOptionHandlers() {
        return Collections.unmodifiableList(this.optionHandlers);
    }

    public List<Handler> getArgumentHandlers() {
        return Collections.unmodifiableList(this.argumentHandlers);
    }

    public boolean getStopAtNonOption() {
        return this.stopAtNonOption;
    }

    public void setStopAtNonOption(boolean flag) {
        this.stopAtNonOption = flag;
    }

    private void discoverDescriptors() {
        for (Class<?> type = this.bean.getClass(); type != null; type = type.getSuperclass()) {
            Argument argument;
            Option option;
            for (Method method : type.getDeclaredMethods()) {
                option = method.getAnnotation(Option.class);
                if (option != null) {
                    this.addOption(new MethodSetter(this.bean, method), option);
                }
                if ((argument = method.getAnnotation(Argument.class)) == null) continue;
                this.addArgument(new MethodSetter(this.bean, method), argument);
            }
            for (AccessibleObject accessibleObject : type.getDeclaredFields()) {
                option = ((Field)accessibleObject).getAnnotation(Option.class);
                if (option != null) {
                    this.addOption(this.createFieldSetter((Field)accessibleObject), option);
                }
                if ((argument = ((Field)accessibleObject).getAnnotation(Argument.class)) == null) continue;
                this.addArgument(this.createFieldSetter((Field)accessibleObject), argument);
            }
        }
        for (int i = 0; i < this.argumentHandlers.size(); ++i) {
            if (this.argumentHandlers.get(i) != null) continue;
            throw new IllegalAnnotationError("No argument annotation for index: " + i);
        }
    }

    private Setter createFieldSetter(Field field) {
        assert (field != null);
        if (Collection.class.isAssignableFrom(field.getType())) {
            return new CollectionFieldSetter(this.bean, field);
        }
        return new FieldSetter(this.bean, field);
    }

    private void addArgument(Setter setter, Argument argument) {
        Handler handler = Handlers.create(new ArgumentDescriptor(argument, setter.isMultiValued()), setter);
        int index = argument.index();
        while (index >= this.argumentHandlers.size()) {
            this.argumentHandlers.add(null);
        }
        if (this.argumentHandlers.get(index) != null) {
            throw new IllegalAnnotationError("Duplicate argument index: " + index);
        }
        this.argumentHandlers.set(index, handler);
    }

    private void addOption(Setter setter, Option option) {
        Handler handler = Handlers.create(new OptionDescriptor(option, setter.isMultiValued()), setter);
        this.checkOptionNotInMap(option.name());
        for (String alias : option.aliases()) {
            this.checkOptionNotInMap(alias);
        }
        this.optionHandlers.add(handler);
    }

    private void checkOptionNotInMap(String name) throws IllegalAnnotationError {
        if (this.findOptionByName(name) != null) {
            throw new IllegalAnnotationError("Duplicate option name: " + name);
        }
    }

    public void process(String ... args) throws ProcessingException {
        ParametersImpl params = new ParametersImpl(args);
        HashSet<Handler> present = new HashSet<Handler>();
        int argIndex = 0;
        boolean processOptions = true;
        boolean requireOverride = false;
        while (params.hasMore()) {
            Handler handler;
            String arg = params.current();
            if (processOptions && arg.startsWith("-")) {
                boolean isKeyValuePair = arg.indexOf(61) != -1;
                Handler handler2 = handler = isKeyValuePair ? this.findOptionHandler(arg) : this.findOptionByName(arg);
                if (handler == null) {
                    if (this.stopAtNonOption) {
                        processOptions = false;
                        continue;
                    }
                    throw new ProcessingException(Messages.UNDEFINED_OPTION.format(arg));
                }
                if (isKeyValuePair) {
                    handler.isKeyValuePair = isKeyValuePair;
                } else {
                    params.skip(1);
                }
            } else {
                if (argIndex >= this.argumentHandlers.size()) {
                    Messages msg = this.argumentHandlers.size() == 0 ? Messages.NO_ARGUMENT_ALLOWED : Messages.TOO_MANY_ARGUMENTS;
                    throw new ProcessingException(msg.format(arg));
                }
                handler = this.argumentHandlers.get(argIndex);
                if (!handler.descriptor.isMultiValued()) {
                    ++argIndex;
                }
            }
            try {
                params.handler = handler;
                if (!requireOverride && handler.descriptor instanceof OptionDescriptor) {
                    OptionDescriptor d = (OptionDescriptor)handler.descriptor;
                    requireOverride = d.isRequireOverride();
                }
                int consumed = handler.handle(params);
                params.skip(consumed);
            }
            catch (StopProcessingOptionsNotification n) {
                processOptions = false;
            }
            present.add(handler);
        }
        if (!requireOverride) {
            for (Handler handler : this.optionHandlers) {
                if (!handler.descriptor.required() || present.contains(handler)) continue;
                throw new ProcessingException(Messages.REQUIRED_OPTION_MISSING.format(handler.descriptor.toString()));
            }
            for (Handler handler : this.argumentHandlers) {
                if (!handler.descriptor.required() || present.contains(handler)) continue;
                throw new ProcessingException(Messages.REQUIRED_ARGUMENT_MISSING.format(handler.descriptor.toString()));
            }
        }
    }

    private Handler findOptionHandler(String name) {
        Handler handler = this.findOptionByName(name);
        if (handler == null) {
            for (int i = name.length(); i > 1; --i) {
                String prefix = name.substring(0, i);
                Map<String, Handler> possibleHandlers = this.filter(this.optionHandlers, prefix);
                handler = possibleHandlers.get(prefix);
                if (handler == null) continue;
                return handler;
            }
        }
        return handler;
    }

    private Map<String, Handler> filter(List<Handler> handlers, String keyFilter) {
        TreeMap<String, Handler> map = new TreeMap<String, Handler>();
        for (Handler handler : handlers) {
            if (keyFilter.contains("--")) {
                for (String alias : ((OptionDescriptor)handler.descriptor).aliases()) {
                    if (!alias.startsWith(keyFilter)) continue;
                    map.put(alias, handler);
                }
                continue;
            }
            if (!((OptionDescriptor)handler.descriptor).name().startsWith(keyFilter)) continue;
            map.put(((OptionDescriptor)handler.descriptor).name(), handler);
        }
        return map;
    }

    private Handler findOptionByName(String name) {
        for (Handler handler : this.optionHandlers) {
            OptionDescriptor option = (OptionDescriptor)handler.descriptor;
            if (name.equals(option.name())) {
                return handler;
            }
            for (String alias : option.aliases()) {
                if (!name.equals(alias)) continue;
                return handler;
            }
        }
        return null;
    }

    private class ParametersImpl
    implements Parameters {
        private final String[] args;
        private int pos = 0;
        private Handler handler;

        public ParametersImpl(String[] args) {
            assert (args != null);
            this.args = args;
        }

        private boolean hasMore() {
            return this.pos < this.args.length;
        }

        private String current() {
            return this.args[this.pos];
        }

        private void skip(int n) {
            this.pos += n;
        }

        private String getOptionName() {
            return this.handler.descriptor.toString();
        }

        public String get(int idx) throws ProcessingException {
            if (this.pos + idx >= this.args.length) {
                throw new ProcessingException(Messages.MISSING_OPERAND.format(this.getOptionName()));
            }
            return this.args[this.pos + idx];
        }
    }
}

