/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.clp.setter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.geronimo.gshell.clp.IllegalAnnotationError;
import org.apache.geronimo.gshell.clp.ProcessingException;
import org.apache.geronimo.gshell.clp.setter.Messages;
import org.apache.geronimo.gshell.clp.setter.Setter;

public class MethodSetter
implements Setter {
    private final Object bean;
    private final Method method;

    public MethodSetter(Object bean, Method method) {
        assert (bean != null);
        assert (method != null);
        this.bean = bean;
        this.method = method;
        if (method.getParameterTypes().length != 1) {
            throw new IllegalAnnotationError(Messages.ILLEGAL_METHOD_SIGNATURE.format(method));
        }
    }

    public Class getType() {
        return this.method.getParameterTypes()[0];
    }

    public boolean isMultiValued() {
        return false;
    }

    public void set(Object value) throws ProcessingException {
        try {
            try {
                this.method.invoke(this.bean, value);
            }
            catch (IllegalAccessException ignore) {
                this.method.setAccessible(true);
                try {
                    this.method.invoke(this.bean, value);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalAccessError(e.getMessage());
                }
            }
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof ProcessingException) {
                throw (ProcessingException)t;
            }
            if (t != null) {
                throw new ProcessingException(t);
            }
            throw new ProcessingException(e);
        }
    }
}

