/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.command;

import org.apache.geronimo.gshell.clp.CommandLineProcessor;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.clp.Printer;
import org.apache.geronimo.gshell.command.Command;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.command.IO;
import org.apache.geronimo.gshell.command.Variables;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.common.Arguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommandSupport
implements Command {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected CommandContext context;
    protected IO io;
    protected Variables variables;
    @Option(name="-h", aliases={"--help"}, description="Display this help message", requireOverride=true)
    private boolean displayHelp;

    @Deprecated
    public String getId() {
        CommandComponent cmd = this.getClass().getAnnotation(CommandComponent.class);
        if (cmd == null) {
            throw new IllegalStateException("Command id not found");
        }
        return cmd.id();
    }

    @Deprecated
    public String getDescription() {
        CommandComponent cmd = this.getClass().getAnnotation(CommandComponent.class);
        if (cmd == null) {
            throw new IllegalStateException("Command description not found");
        }
        return cmd.description();
    }

    public void init(CommandContext context) {
        assert (context != null);
        this.context = context;
        this.io = context.getIO();
        this.variables = context.getVariables();
        String id = this.getId();
        this.log = LoggerFactory.getLogger((String)(this.getClass().getName() + "." + id));
    }

    public Object execute(CommandContext context, Object ... args) throws Exception {
        assert (context != null);
        assert (args != null);
        this.init(context);
        this.log.info("Executing w/args: [{}]", (Object)Arguments.asString(args));
        CommandLineProcessor clp = new CommandLineProcessor(this);
        clp.process(Arguments.toStringArray(args));
        if (this.displayHelp) {
            this.displayHelp(context, clp);
            return SUCCESS;
        }
        return this.doExecute();
    }

    protected abstract Object doExecute() throws Exception;

    protected void displayHelp(CommandContext context, CommandLineProcessor clp) {
        assert (context != null);
        assert (clp != null);
        String name = context.getInfo().getAlias();
        if (name == null) {
            name = context.getInfo().getName();
        }
        Printer printer = new Printer(clp);
        printer.printUsage(this.io.out, name);
        this.io.out.println();
    }
}

