/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.common;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class NamedThreadFactory
implements ThreadFactory {
    private final String baseName;
    private final ThreadGroup group;
    private final AtomicLong counter = new AtomicLong(0L);

    public NamedThreadFactory(String baseName, ThreadGroup group) {
        assert (baseName != null);
        assert (group != null);
        this.baseName = baseName;
        this.group = group;
    }

    public NamedThreadFactory(String baseName) {
        this(baseName, Thread.currentThread().getThreadGroup());
    }

    public NamedThreadFactory(Class type) {
        this(type.getSimpleName());
    }

    public NamedThreadFactory(Class type, String suffix) {
        this(type.getSimpleName() + "-" + suffix);
    }

    public String getBaseName() {
        return this.baseName;
    }

    public ThreadGroup getGroup() {
        return this.group;
    }

    public long current() {
        return this.counter.get();
    }

    public Thread newThread(Runnable task) {
        assert (task != null);
        Thread t = new Thread(this.group, task, this.createName());
        this.configure(t);
        return t;
    }

    protected String createName() {
        return this.baseName + "-" + this.counter.getAndIncrement();
    }

    protected void configure(Thread t) {
        t.setDaemon(true);
    }
}

