/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.expression;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.apache.commons.jexl.resolver.FlatResolver;
import org.apache.geronimo.gshell.command.Variables;
import org.apache.geronimo.gshell.expression.ExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JexlExpressionEvaluator
implements ExpressionEvaluator {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final JexlContext context;
    private final FlatResolver resolver = new FlatResolver(true);

    public JexlExpressionEvaluator(Map vars) {
        assert (vars != null);
        this.context = JexlHelper.createContext();
        this.context.setVars(vars);
        this.log.trace("Using variables: {}", (Object)this.context.getVars());
    }

    private static Map convertToMap(Variables vars) {
        assert (vars != null);
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator<String> iter = vars.names();
        while (iter.hasNext()) {
            String name = iter.next();
            map.put(name, vars.get(name));
        }
        return map;
    }

    public JexlExpressionEvaluator(Variables vars) {
        this(JexlExpressionEvaluator.convertToMap(vars));
    }

    public Map getVariables() {
        return this.context.getVars();
    }

    protected Expression createExpression(String expression) throws Exception {
        assert (expression != null);
        Expression expr = ExpressionFactory.createExpression(expression);
        expr.addPreResolver(this.resolver);
        return expr;
    }

    public Object evaluate(String expression) throws Exception {
        assert (expression != null);
        this.log.debug("Evaluating expression: {}", (Object)expression);
        Expression expr = this.createExpression(expression);
        Object result = expr.evaluate(this.context);
        this.log.debug("Result: {}", result);
        return result;
    }

    public String parse(String input) throws ExpressionEvaluator.SyntaxException {
        assert (input != null);
        this.log.trace("Parsing input: {}", (Object)input);
        StringBuffer buff = new StringBuffer();
        int current = 0;
        while (current < input.length()) {
            int end;
            boolean complex = false;
            int start = input.indexOf("$", current);
            if (start == -1) break;
            if (start + 1 < input.length() && input.charAt(start + 1) == '{') {
                complex = true;
            }
            if (complex) {
                end = input.indexOf("}", start);
                if (end == -1) {
                    throw new ExpressionEvaluator.SyntaxException("Missing '}': " + input);
                }
            } else {
                end = input.indexOf(" ", start);
                if (end == -1 && (end = input.indexOf("\t", start)) == -1) {
                    end = input.length();
                }
            }
            String expr = input.substring(start + (complex ? 2 : 1), end);
            String tmp = input.substring(current, start);
            buff.append(tmp);
            try {
                buff.append(this.evaluate(expr));
            }
            catch (Exception e) {
                throw new ExpressionEvaluator.SyntaxException("Failed to evaluate: " + expr, e);
            }
            current = end + (complex ? 1 : 0);
        }
        if (current < input.length()) {
            String tmp = input.substring(current);
            buff.append(tmp);
        }
        this.log.trace("Parsed result: {}", (Object)buff);
        return buff.toString();
    }

    public String parse(String input, boolean trim) throws ExpressionEvaluator.SyntaxException {
        String output = this.parse(input);
        if (trim && output != null) {
            output = output.trim();
        }
        return output;
    }
}

