/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.layout;

import java.io.IOException;
import org.apache.geronimo.gshell.layout.LayoutManager;
import org.apache.geronimo.gshell.layout.NotFoundException;
import org.apache.geronimo.gshell.layout.loader.LayoutLoader;
import org.apache.geronimo.gshell.layout.model.GroupNode;
import org.apache.geronimo.gshell.layout.model.Layout;
import org.apache.geronimo.gshell.layout.model.Node;
import org.apache.geronimo.gshell.shell.Environment;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=LayoutManager.class)
public class DefaultLayoutManager
implements LayoutManager,
Initializable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Requirement
    private LayoutLoader loader;
    @Requirement
    private Environment env;
    private Layout layout;

    public DefaultLayoutManager() {
    }

    public DefaultLayoutManager(LayoutLoader loader, Environment env) {
        this.loader = loader;
        this.env = env;
    }

    public void initialize() throws InitializationException {
        assert (this.loader != null);
        try {
            this.layout = this.loader.load();
        }
        catch (IOException e) {
            throw new InitializationException(e.getMessage(), e);
        }
    }

    public Layout getLayout() {
        return this.layout;
    }

    public Node findNode(String path) throws NotFoundException {
        return this.findNode(path, null);
    }

    public Node findNode(String path, String searchPath) throws NotFoundException {
        assert (path != null);
        if (path.startsWith("/")) {
            Layout start = this.layout;
            return this.findNode(start, path);
        }
        if (searchPath != null) {
            String[] pathList = searchPath.split(":");
            Node foundNode = null;
            for (String commandPath : pathList) {
                try {
                    Node pathNode = this.findNode(commandPath);
                    foundNode = this.findNode(pathNode, path);
                    if (foundNode == null) continue;
                    break;
                }
                catch (NotFoundException e) {
                    // empty catch block
                }
            }
            if (foundNode == null) {
                foundNode = this.findNode(this.layout, path);
            }
            return foundNode;
        }
        Node start = (Node)this.env.getVariables().get(CURRENT_NODE);
        if (start == null) {
            start = this.layout;
        }
        return this.findNode(start, path);
    }

    public Node findNode(Node start, String path) throws NotFoundException {
        String[] elements;
        assert (start != null);
        assert (path != null);
        Node current = start;
        for (String element : elements = path.split("/")) {
            Node node;
            if (current instanceof GroupNode) {
                node = ((GroupNode)current).find(element);
                if (node == null) {
                    throw new NotFoundException(path);
                }
            } else {
                throw new NotFoundException(path);
            }
            current = node;
        }
        return current;
    }
}

