/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.layout.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.geronimo.gshell.layout.model.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="group")
public class GroupNode
extends Node {
    protected Set<Node> nodes = new HashSet<Node>();

    public GroupNode(String name) {
        super(name);
    }

    public void add(Node child) {
        assert (child != null);
        child.setParent(this);
        this.nodes.add(child);
    }

    public Node find(String name) {
        assert (name != null);
        for (Node child : this.nodes) {
            if (!name.equals(child.getName())) continue;
            return child;
        }
        return null;
    }

    public Set<Node> nodes() {
        return Collections.unmodifiableSet(this.nodes);
    }

    public int size() {
        return this.nodes.size();
    }

    public boolean isEmpty() {
        return this.nodes == null || this.nodes.isEmpty();
    }

    private Object readResolve() {
        if (!this.isEmpty()) {
            for (Node child : this.nodes) {
                child.setParent(this);
            }
        }
        return this;
    }
}

