/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.spring;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.support.OsgiCommandSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CommandComponent(id="smx:create", description="Create a new ServiceMix instance")
public class CreateCommand
extends OsgiCommandSupport {
    @Argument(index=0, required=true, description="Where to create the new ServiceMix instance")
    private String instance = null;

    @Override
    protected Object doExecute() throws Exception {
        File serviceMixBase = new File(this.instance).getCanonicalFile();
        this.io.out.println("Creating new instance at: @|bold " + serviceMixBase + "|");
        this.mkdir(serviceMixBase, "bin");
        this.mkdir(serviceMixBase, "etc");
        this.mkdir(serviceMixBase, "system");
        this.mkdir(serviceMixBase, "deploy");
        this.mkdir(serviceMixBase, "data");
        this.copyResourceToDir(serviceMixBase, "etc/config.properties", true);
        this.copyResourceToDir(serviceMixBase, "etc/org.apache.servicemix.features.cfg", true);
        this.copyResourceToDir(serviceMixBase, "etc/org.apache.servicemix.shell.cfg", true);
        this.copyResourceToDir(serviceMixBase, "etc/org.ops4j.pax.logging.cfg", true);
        this.copyResourceToDir(serviceMixBase, "etc/startup.properties", true);
        this.copyResourceToDir(serviceMixBase, "etc/system.properties", true);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("${servicemix.home}", System.getProperty("servicemix.home"));
        props.put("${servicemix.base}", serviceMixBase.getPath());
        if (System.getProperty("os.name").startsWith("Win")) {
            this.copyFilteredResourceToDir(serviceMixBase, "bin/servicemix.bat", props);
        } else {
            this.copyFilteredResourceToDir(serviceMixBase, "bin/servicemix", props);
            this.chmod(new File(serviceMixBase, "bin/servicemix"), "a+x");
        }
        return SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResourceToDir(File target, String resource, boolean text) throws Exception {
        block13: {
            File outFile = new File(target, resource);
            if (!outFile.exists()) {
                this.io.out.println("Creating file: @|bold " + outFile.getPath() + "|");
                InputStream is = CreateCommand.class.getResourceAsStream(resource);
                try {
                    if (text) {
                        PrintStream out = new PrintStream(new FileOutputStream(outFile));
                        try {
                            Scanner scanner = new Scanner(is);
                            while (scanner.hasNextLine()) {
                                String line = scanner.nextLine();
                                out.println(line);
                            }
                            break block13;
                        }
                        finally {
                            this.safeClose(out);
                        }
                    }
                    FileOutputStream out = new FileOutputStream(new File(target, resource));
                    try {
                        int c = 0;
                        while ((c = is.read()) >= 0) {
                            out.write(c);
                        }
                    }
                    finally {
                        this.safeClose(out);
                    }
                }
                finally {
                    this.safeClose(is);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFilteredResourceToDir(File target, String resource, HashMap<String, String> props) throws Exception {
        File outFile = new File(target, resource);
        if (!outFile.exists()) {
            this.io.out.println("Creating file: @|bold " + outFile.getPath() + "|");
            InputStream is = CreateCommand.class.getResourceAsStream(resource);
            try {
                PrintStream out = new PrintStream(new FileOutputStream(outFile));
                try {
                    Scanner scanner = new Scanner(is);
                    while (scanner.hasNextLine()) {
                        String line = scanner.nextLine();
                        line = this.filter(line, props);
                        out.println(line);
                    }
                }
                finally {
                    this.safeClose(out);
                }
            }
            finally {
                this.safeClose(is);
            }
        }
    }

    private void safeClose(InputStream is) throws IOException {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void safeClose(OutputStream is) throws IOException {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String filter(String line, HashMap<String, String> props) {
        for (Map.Entry<String, String> i : props.entrySet()) {
            int p1 = line.indexOf(i.getKey());
            if (p1 < 0) continue;
            String l1 = line.substring(0, p1);
            String l2 = line.substring(p1 + i.getKey().length());
            line = l1 + i.getValue() + l2;
        }
        return line;
    }

    private void mkdir(File serviceMixBase, String path) {
        File file = new File(serviceMixBase, path);
        if (!file.exists()) {
            this.io.out.println("Creating dir:  @|bold " + file.getPath() + "|");
            file.mkdirs();
        }
    }

    private int chmod(File serviceFile, String mode) throws Exception {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command("chmod", mode, serviceFile.getCanonicalPath());
        Process p = builder.start();
        int status = p.waitFor();
        return status;
    }
}

