/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.spring;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.geronimo.gshell.DefaultEnvironment;
import org.apache.geronimo.gshell.DefaultShell;
import org.apache.geronimo.gshell.ExitNotification;
import org.apache.geronimo.gshell.command.IO;
import org.apache.geronimo.gshell.common.Arguments;
import org.apache.geronimo.gshell.console.Console;
import org.apache.geronimo.gshell.layout.NotFoundException;
import org.apache.geronimo.gshell.shell.Environment;
import org.apache.geronimo.gshell.shell.InteractiveShell;
import org.apache.geronimo.gshell.spring.EnvironmentTargetSource;
import org.apache.geronimo.gshell.spring.NoCloseInputStream;
import org.apache.geronimo.gshell.spring.NoCloseOutputStream;
import org.apache.geronimo.gshell.spring.ProxyIO;
import org.apache.servicemix.kernel.main.spi.MainService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.osgi.context.BundleContextAware;

public class GShell
implements Runnable,
BundleContextAware {
    private static final Logger log = LoggerFactory.getLogger(GShell.class);
    private InteractiveShell shell;
    private Thread thread;
    private IO io;
    private Environment env;
    private boolean start;
    private MainService mainService;
    private BundleContext bundleContext;
    private CountDownLatch frameworkStarted;
    private volatile boolean closed;

    public GShell(InteractiveShell shell) throws IOException {
        this.shell = shell;
        if (shell instanceof DefaultShell) {
            DefaultShell sh = (DefaultShell)shell;
            sh.setErrorHandler(this.wrapErrorHandler(sh.getErrorHandler()));
        }
        this.io = new IO((InputStream)new NoCloseInputStream(System.in), (OutputStream)new NoCloseOutputStream(System.out), new NoCloseOutputStream(System.err));
        this.env = new DefaultEnvironment(new ProxyIO());
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    public void start() {
        this.frameworkStarted = new CountDownLatch(1);
        this.getBundleContext().addFrameworkListener(new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                log.debug("Got event: " + event.getType());
                if (event.getType() == 1) {
                    GShell.this.frameworkStarted.countDown();
                }
            }
        });
        if (this.start) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void stop() throws Exception {
        this.closed = true;
        this.io.close();
        if (this.thread != null) {
            this.frameworkStarted.countDown();
            this.thread.interrupt();
            this.thread.join();
            this.thread = null;
        }
    }

    public void run() {
        try {
            ProxyIO.setIO(this.io);
            EnvironmentTargetSource.setEnvironment(this.env);
            Object[] args = null;
            if (this.mainService != null) {
                args = this.mainService.getArgs();
            }
            if (args != null && args.length > 0) {
                this.waitForFrameworkToStart();
                log.info("Executing Shell with arguments: " + Arguments.asString(args));
                Object value = this.shell.execute(args);
                if (this.mainService != null) {
                    if (value instanceof Number) {
                        this.mainService.setExitCode(((Number)value).intValue());
                    } else {
                        this.mainService.setExitCode(value != null ? 1 : 0);
                    }
                    log.info("Exiting shell due to terminated command");
                    try {
                        this.getBundleContext().getBundle(0L).stop();
                    }
                    catch (BundleException e2) {
                        log.info("Caught exception while shutting down framework: " + (Object)((Object)e2), (Throwable)e2);
                    }
                }
            } else {
                this.shell.run(new Object[0]);
            }
        }
        catch (Throwable e) {
            if (e instanceof ExitNotification) {
                if (this.closed) {
                    return;
                }
                if (this.mainService != null) {
                    this.mainService.setExitCode(0);
                }
                log.info("Exiting shell due received exit notification");
            } else {
                if (this.mainService != null) {
                    this.mainService.setExitCode(-1);
                }
                log.info("Exiting shell due to caught exception " + e, e);
            }
            new Thread(){

                public void run() {
                    try {
                        GShell.this.getBundleContext().getBundle(0L).stop();
                    }
                    catch (BundleException e2) {
                        log.info("Caught exception while shutting down framework: " + (Object)((Object)e2), (Throwable)e2);
                    }
                }
            }.start();
        }
    }

    private void waitForFrameworkToStart() throws InterruptedException {
        if (this.frameworkStarted.await(5L, TimeUnit.SECONDS)) {
            log.info("System completed startup.");
        } else {
            log.warn("System took too long startup... continuing");
        }
    }

    public MainService getMainService() {
        return this.mainService;
    }

    public void setMainService(MainService main) {
        this.mainService = main;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    protected Console.ErrorHandler wrapErrorHandler(final Console.ErrorHandler handler) {
        return new Console.ErrorHandler(){

            public Console.ErrorHandler.Result handleError(Throwable error) {
                if (GShell.this.closed) {
                    throw new ExitNotification();
                }
                if (error instanceof NotFoundException) {
                    ((GShell)GShell.this).io.err.println("@|bold,red ERROR| Command not found: @|bold,red " + error.getMessage() + "|");
                    return Console.ErrorHandler.Result.CONTINUE;
                }
                return handler.handleError(error);
            }
        };
    }
}

