/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.whisper.transport.base;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.geronimo.gshell.common.Duration;
import org.apache.geronimo.gshell.common.tostring.ReflectionToStringBuilder;
import org.apache.geronimo.gshell.common.tostring.ToStringStyle;
import org.apache.geronimo.gshell.whisper.message.Message;
import org.apache.geronimo.gshell.whisper.request.Requestor;
import org.apache.geronimo.gshell.whisper.stream.SessionInputStream;
import org.apache.geronimo.gshell.whisper.stream.SessionOutputStream;
import org.apache.geronimo.gshell.whisper.transport.Session;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;

public class SessionAdapter
implements Session {
    private final IoSession session;
    private boolean closed;

    public SessionAdapter(IoSession session) {
        assert (session != null);
        this.session = session;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public IoSession getSession() {
        this.ensureOpened();
        return this.session;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    protected void ensureOpened() {
        if (this.isClosed()) {
            throw new IllegalStateException("Closed");
        }
    }

    public synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        this.session.close();
        this.closed = true;
    }

    public WriteFuture send(Object msg) throws Exception {
        assert (msg != null);
        this.ensureOpened();
        return this.session.write(msg);
    }

    public Message request(Message msg) throws Exception {
        assert (msg != null);
        this.ensureOpened();
        Requestor requestor = new Requestor(this);
        return requestor.request(msg);
    }

    public Message request(Message msg, Duration timeout) throws Exception {
        assert (msg != null);
        assert (timeout != null);
        this.ensureOpened();
        Requestor requestor = new Requestor(this);
        return requestor.request(msg, timeout);
    }

    public InputStream getInputStream() {
        this.ensureOpened();
        return SessionInputStream.BINDER.lookup(this.session);
    }

    public OutputStream getOutputStream() {
        this.ensureOpened();
        return SessionOutputStream.BINDER.lookup(this.session);
    }

    public OutputStream getErrorStream() {
        this.ensureOpened();
        throw new UnsupportedOperationException();
    }
}

