/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.whisper.util;

import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionAttributeBinder<T> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String key;

    public SessionAttributeBinder(String key) {
        assert (key != null);
        this.key = key;
    }

    public SessionAttributeBinder(Class type) {
        this(type.getName());
    }

    public SessionAttributeBinder(Class type, String suffix) {
        this(type.getName() + "." + suffix);
    }

    public boolean isBound(IoSession session) {
        assert (session != null);
        return session.containsAttribute(this.key);
    }

    public T lookup(IoSession session) {
        assert (session != null);
        Object obj = session.getAttribute(this.key);
        if (obj == null) {
            throw new NotBoundException(this.key);
        }
        return (T)obj;
    }

    public T lookup(IoSession session, T defaultValue) {
        assert (session != null);
        Object obj = session.getAttribute(this.key);
        if (obj == null) {
            return defaultValue;
        }
        return (T)obj;
    }

    public T bind(IoSession session, T obj) {
        assert (session != null);
        assert (obj != null);
        Object prev = session.getAttribute(this.key);
        if (prev != null) {
            throw new AlreadyBoundException(this.key);
        }
        session.setAttribute(this.key, obj);
        this.log.trace("Bound {} ", obj);
        return obj;
    }

    public T rebind(IoSession session, T obj) {
        assert (session != null);
        assert (obj != null);
        Object prev = session.getAttribute(this.key);
        session.setAttribute(this.key, obj);
        this.log.trace("Rebound {}", obj);
        return (T)prev;
    }

    public T unbind(IoSession session) {
        assert (session != null);
        Object obj = session.removeAttribute(this.key);
        this.log.trace("Unbound {}", obj);
        return (T)obj;
    }

    public static class AlreadyBoundException
    extends RuntimeException {
        public AlreadyBoundException(String key) {
            super(key);
        }
    }

    public static class NotBoundException
    extends RuntimeException {
        public NotBoundException(String key) {
            super(key);
        }
    }
}

