/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.deployer.Component;
import org.apache.servicemix.jbi.deployer.ServiceUnit;
import org.apache.servicemix.jbi.deployer.descriptor.ComponentDesc;
import org.apache.servicemix.jbi.deployer.impl.Deployer;
import org.apache.servicemix.jbi.deployer.impl.ServiceAssemblyImpl;
import org.apache.servicemix.jbi.deployer.impl.ServiceUnitImpl;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentImpl
implements Component,
org.apache.servicemix.jbi.runtime.ComponentWrapper {
    private static final Log LOGGER = LogFactory.getLog(ComponentImpl.class);
    private static final String STATE = "state";
    private ComponentDesc componentDesc;
    private javax.jbi.component.Component component;
    private State state = State.Unknown;
    private Preferences prefs;
    private State runningState;
    private Deployer deployer;
    private List<ServiceUnitImpl> serviceUnits;

    public ComponentImpl(ComponentDesc componentDesc, javax.jbi.component.Component component, Preferences prefs, boolean autoStart, Deployer deployer) {
        this.componentDesc = componentDesc;
        this.component = new ComponentWrapper(component);
        this.prefs = prefs;
        this.runningState = State.valueOf(this.prefs.get(STATE, (autoStart ? State.Started : State.Initialized).name()));
        this.deployer = deployer;
        this.serviceUnits = new ArrayList<ServiceUnitImpl>();
    }

    public void addServiceUnit(ServiceUnitImpl serviceUnit) {
        this.serviceUnits.add(serviceUnit);
    }

    public void removeServiceUnit(ServiceUnitImpl serviceUnit) {
        this.serviceUnits.remove(serviceUnit);
    }

    @Override
    public ServiceUnit[] getServiceUnits() {
        return this.serviceUnits.toArray(new ServiceUnit[this.serviceUnits.size()]);
    }

    @Override
    public String getName() {
        return this.componentDesc.getIdentification().getName();
    }

    @Override
    public String getDescription() {
        return this.componentDesc.getIdentification().getDescription();
    }

    public ObjectName getExtensionMBeanName() throws JBIException {
        return this.component.getLifeCycle().getExtensionMBeanName();
    }

    @Override
    public javax.jbi.component.Component getComponent() {
        return this.component;
    }

    public void start() throws JBIException {
        this.start(true);
    }

    public void start(boolean saveState) throws JBIException {
        LOGGER.info((Object)("Starting component " + this.getName()));
        this.component.getLifeCycle().start();
        this.state = State.Started;
        if (saveState) {
            this.saveState();
        }
    }

    public void stop() throws JBIException {
        this.stop(true);
    }

    protected Set<ServiceAssemblyImpl> getServiceAssemblies() {
        HashSet<ServiceAssemblyImpl> sas = new HashSet<ServiceAssemblyImpl>();
        for (ServiceUnitImpl su : this.serviceUnits) {
            sas.add(su.getServiceAssemblyImpl());
        }
        return sas;
    }

    public void stop(boolean saveState) throws JBIException {
        LOGGER.info((Object)("Stopping component " + this.getName()));
        if (this.state == State.Started) {
            for (ServiceAssemblyImpl sa : this.getServiceAssemblies()) {
                sa.stop(false);
            }
            this.component.getLifeCycle().stop();
            this.state = State.Stopped;
            if (saveState) {
                this.saveState();
            }
        }
    }

    public void shutDown() throws JBIException {
        this.shutDown(true);
    }

    public void shutDown(boolean saveState) throws JBIException {
        LOGGER.info((Object)("Shutting down component " + this.getName()));
        if (this.state == State.Started) {
            this.stop(saveState);
        }
        if (this.state == State.Stopped) {
            for (ServiceAssemblyImpl sa : this.getServiceAssemblies()) {
                sa.shutDown(false);
            }
            this.component.getLifeCycle().shutDown();
            this.state = State.Shutdown;
            if (saveState) {
                this.saveState();
            }
        }
    }

    private void saveState() {
        this.prefs.put(STATE, this.state.name());
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException e) {
            LOGGER.warn((Object)"Unable to persist state", (Throwable)e);
        }
    }

    public String getCurrentState() {
        switch (this.state) {
            case Started: {
                return "Started";
            }
            case Stopped: {
                return "Stopped";
            }
            case Initialized: 
            case Shutdown: {
                return "Shutdown";
            }
        }
        return "Unknown";
    }

    public State getState() {
        return this.state;
    }

    protected class ComponentWrapper
    implements javax.jbi.component.Component,
    ComponentLifeCycle {
        private javax.jbi.component.Component component;
        private ComponentLifeCycle lifeCycle;

        public ComponentWrapper(javax.jbi.component.Component component) {
            this.component = component;
        }

        public ComponentLifeCycle getLifeCycle() {
            if (this.lifeCycle == null) {
                this.lifeCycle = this.component.getLifeCycle();
            }
            return this;
        }

        public ServiceUnitManager getServiceUnitManager() {
            return this.component.getServiceUnitManager();
        }

        public Document getServiceDescription(ServiceEndpoint endpoint) {
            return this.component.getServiceDescription(endpoint);
        }

        public boolean isExchangeWithConsumerOkay(ServiceEndpoint endpoint, MessageExchange exchange) {
            return this.component.isExchangeWithConsumerOkay(endpoint, exchange);
        }

        public boolean isExchangeWithProviderOkay(ServiceEndpoint endpoint, MessageExchange exchange) {
            return this.component.isExchangeWithProviderOkay(endpoint, exchange);
        }

        public ServiceEndpoint resolveEndpointReference(DocumentFragment epr) {
            return this.component.resolveEndpointReference(epr);
        }

        public ObjectName getExtensionMBeanName() {
            return this.lifeCycle.getExtensionMBeanName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init(ComponentContext context) throws JBIException {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.component.getClass().getClassLoader());
                this.lifeCycle.init(context);
                ComponentImpl.this.state = State.Initialized;
                if (ComponentImpl.this.runningState == State.Started) {
                    this.start();
                    ComponentImpl.this.state = State.Started;
                } else if (ComponentImpl.this.runningState == State.Stopped) {
                    this.start();
                    ComponentImpl.this.state = State.Started;
                    this.stop();
                    ComponentImpl.this.state = State.Stopped;
                } else if (ComponentImpl.this.runningState == State.Shutdown) {
                    this.shutDown();
                    ComponentImpl.this.state = State.Shutdown;
                }
                ComponentImpl.this.deployer.checkPendingBundles();
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }

        public void shutDown() throws JBIException {
            this.lifeCycle.shutDown();
        }

        public void start() throws JBIException {
            this.lifeCycle.start();
        }

        public void stop() throws JBIException {
            this.lifeCycle.stop();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum State {
        Unknown,
        Initialized,
        Started,
        Stopped,
        Shutdown;

    }
}

