/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.impl;

import java.net.URL;
import org.apache.servicemix.jbi.deployer.SharedLibrary;
import org.apache.servicemix.jbi.deployer.descriptor.ClassPath;
import org.apache.servicemix.jbi.deployer.descriptor.SharedLibraryDesc;
import org.apache.xbean.classloader.MultiParentClassLoader;
import org.osgi.framework.Bundle;
import org.springframework.osgi.util.BundleDelegatingClassLoader;

public class SharedLibraryImpl
implements SharedLibrary {
    private SharedLibraryDesc library;
    private Bundle bundle;
    private ClassLoader classLoader;

    public SharedLibraryImpl(SharedLibraryDesc library, Bundle bundle) {
        this.library = library;
        this.bundle = bundle;
    }

    public String getName() {
        return this.library.getIdentification().getName();
    }

    public String getDescription() {
        return this.library.getIdentification().getDescription();
    }

    public String getVersion() {
        return this.library.getVersion();
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            BundleDelegatingClassLoader parent = BundleDelegatingClassLoader.createBundleClassLoaderFor((Bundle)this.bundle, (ClassLoader)this.getClass().getClassLoader());
            boolean parentFirst = this.library.isParentFirstClassLoaderDelegation();
            ClassPath cp = this.library.getSharedLibraryClassPath();
            String[] classPathNames = cp.getPathElements();
            URL[] urls = new URL[classPathNames.length];
            for (int i = 0; i < classPathNames.length; ++i) {
                urls[i] = this.bundle.getResource(classPathNames[i]);
                if (urls[i] != null) continue;
                throw new IllegalArgumentException("SharedLibrary classpath entry not found: '" + classPathNames[i] + "'");
            }
            this.classLoader = new MultiParentClassLoader(this.library.getIdentification().getName(), urls, (ClassLoader)parent, !parentFirst, new String[0], new String[]{"java.", "javax."});
        }
        return this.classLoader;
    }
}

