/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.obr;

import java.util.List;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.obr.ObrCommandSupport;
import org.osgi.framework.Version;
import org.osgi.service.obr.RepositoryAdmin;
import org.osgi.service.obr.Resource;

@CommandComponent(id="obr:list", description="List")
public class ListCommand
extends ObrCommandSupport {
    @Argument(required=false, multiValued=true)
    List<String> args;

    protected void doExecute(RepositoryAdmin admin) throws Exception {
        String substr = null;
        if (this.args != null) {
            for (String arg : this.args) {
                substr = substr == null ? "" : substr + " ";
                substr = substr + arg;
            }
        }
        StringBuffer sb = new StringBuffer();
        if (substr == null || substr.length() == 0) {
            sb.append("(|(presentationname=*)(symbolicname=*))");
        } else {
            sb.append("(|(presentationname=*");
            sb.append(substr);
            sb.append("*)(symbolicname=*");
            sb.append(substr);
            sb.append("*))");
        }
        Resource[] resources = admin.discoverResources(sb.toString());
        for (int resIdx = 0; resources != null && resIdx < resources.length; ++resIdx) {
            String name = resources[resIdx].getPresentationName();
            Version version = resources[resIdx].getVersion();
            if (version != null) {
                this.io.out.println(name + " (" + version + ")");
                continue;
            }
            this.io.out.println(name);
        }
        if (resources == null) {
            this.io.out.println("No matching bundles.");
        }
    }
}

