/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.obr;

import java.io.PrintWriter;
import java.util.List;
import org.apache.geronimo.gshell.support.OsgiCommandSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.obr.RepositoryAdmin;
import org.osgi.service.obr.Requirement;
import org.osgi.service.obr.Resolver;
import org.osgi.service.obr.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObrCommandSupport
extends OsgiCommandSupport {
    protected static final char VERSION_DELIM = ',';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        ServiceReference ref = this.getBundleContext().getServiceReference(RepositoryAdmin.class.getName());
        if (ref == null) {
            this.io.out.println("RepositoryAdmin service is unavailable.");
            return null;
        }
        try {
            RepositoryAdmin admin = (RepositoryAdmin)this.getBundleContext().getService(ref);
            if (admin == null) {
                this.io.out.println("RepositoryAdmin service is unavailable.");
                Object var3_3 = null;
                return var3_3;
            }
            this.doExecute(admin);
        }
        finally {
            this.getBundleContext().ungetService(ref);
        }
        return null;
    }

    protected abstract void doExecute(RepositoryAdmin var1) throws Exception;

    protected Resource[] searchRepository(RepositoryAdmin admin, String targetId, String targetVersion) {
        try {
            Bundle bundle = this.getBundleContext().getBundle(Long.parseLong(targetId));
            targetId = bundle.getSymbolicName();
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        StringBuffer sb = new StringBuffer("(|(presentationname=");
        sb.append(targetId);
        sb.append(")(symbolicname=");
        sb.append(targetId);
        sb.append("))");
        if (targetVersion != null) {
            sb.insert(0, "(&");
            sb.append("(version=");
            sb.append(targetVersion);
            sb.append("))");
        }
        return admin.discoverResources(sb.toString());
    }

    public Resource selectNewestVersion(Resource[] resources) {
        int idx = -1;
        Version v = null;
        for (int i = 0; resources != null && i < resources.length; ++i) {
            if (i == 0) {
                idx = 0;
                v = resources[i].getVersion();
                continue;
            }
            Version vtmp = resources[i].getVersion();
            if (vtmp.compareTo((Object)v) <= 0) continue;
            idx = i;
            v = vtmp;
        }
        return idx < 0 ? null : resources[idx];
    }

    protected String[] getTarget(String bundle) {
        int idx = bundle.indexOf(44);
        String[] target = idx > 0 ? new String[]{bundle.substring(0, idx), bundle.substring(idx)} : new String[]{bundle, null};
        return target;
    }

    protected void printUnderline(PrintWriter out, int length) {
        for (int i = 0; i < length; ++i) {
            out.print('-');
        }
        out.println("");
    }

    protected void doDeploy(RepositoryAdmin admin, List<String> bundles, boolean start) throws Exception {
        Resolver resolver = admin.resolver();
        for (String bundle : bundles) {
            String[] target = this.getTarget(bundle);
            Resource resource = this.selectNewestVersion(this.searchRepository(admin, target[0], target[1]));
            if (resource != null) {
                resolver.add(resource);
                continue;
            }
            this.io.err.println("Unknown bundle - " + target[0]);
        }
        if (resolver.getAddedResources() != null && resolver.getAddedResources().length > 0) {
            if (resolver.resolve()) {
                int resIdx;
                this.io.out.println("Target resource(s):");
                this.printUnderline(this.io.out, 19);
                Resource[] resources = resolver.getAddedResources();
                for (resIdx = 0; resources != null && resIdx < resources.length; ++resIdx) {
                    this.io.out.println("   " + resources[resIdx].getPresentationName() + " (" + resources[resIdx].getVersion() + ")");
                }
                resources = resolver.getRequiredResources();
                if (resources != null && resources.length > 0) {
                    this.io.out.println("\nRequired resource(s):");
                    this.printUnderline(this.io.out, 21);
                    for (resIdx = 0; resIdx < resources.length; ++resIdx) {
                        this.io.out.println("   " + resources[resIdx].getPresentationName() + " (" + resources[resIdx].getVersion() + ")");
                    }
                }
                if ((resources = resolver.getOptionalResources()) != null && resources.length > 0) {
                    this.io.out.println("\nOptional resource(s):");
                    this.printUnderline(this.io.out, 21);
                    for (resIdx = 0; resIdx < resources.length; ++resIdx) {
                        this.io.out.println("   " + resources[resIdx].getPresentationName() + " (" + resources[resIdx].getVersion() + ")");
                    }
                }
                try {
                    this.io.out.print("\nDeploying...");
                    resolver.deploy(start);
                    this.io.out.println("done.");
                }
                catch (IllegalStateException ex) {
                    this.io.err.println(ex);
                }
            } else {
                Requirement[] reqs = resolver.getUnsatisfiedRequirements();
                if (reqs != null && reqs.length > 0) {
                    this.io.out.println("Unsatisfied requirement(s):");
                    this.printUnderline(this.io.out, 27);
                    for (int reqIdx = 0; reqIdx < reqs.length; ++reqIdx) {
                        this.io.out.println("   " + reqs[reqIdx].getFilter());
                        Resource[] resources = resolver.getResources(reqs[reqIdx]);
                        for (int resIdx = 0; resIdx < resources.length; ++resIdx) {
                            this.io.out.println("      " + resources[resIdx].getPresentationName());
                        }
                    }
                } else {
                    this.io.out.println("Could not resolve targets.");
                }
            }
        }
    }
}

