/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.obr;

import java.net.URL;
import java.util.List;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.obr.FileUtil;
import org.apache.geronimo.gshell.obr.ObrCommandSupport;
import org.osgi.service.obr.RepositoryAdmin;
import org.osgi.service.obr.Resource;

@CommandComponent(id="obr:source", description="Source")
public class SourceCommand
extends ObrCommandSupport {
    @Option(name="-x", description="Extract")
    boolean extract;
    @Argument(required=true, index=0, description="Local directory")
    String localDir;
    @Argument(required=true, index=1, multiValued=true, description="List of bundles")
    List<String> bundles;

    protected void doExecute(RepositoryAdmin admin) throws Exception {
        for (String bundle : this.bundles) {
            String[] target = this.getTarget(bundle);
            Resource resource = this.selectNewestVersion(this.searchRepository(admin, target[0], target[1]));
            if (resource == null) {
                this.io.err.println("Unknown bundle and/or version: " + target[0]);
                continue;
            }
            URL srcURL = (URL)resource.getProperties().get("source");
            if (srcURL != null) {
                FileUtil.downloadSource(this.io.out, this.io.err, srcURL, this.localDir, this.extract);
                continue;
            }
            this.io.err.println("Missing source URL: " + target[0]);
        }
    }
}

