/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.swissbox.property.BundleContextPropertyResolver;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.internal.ConfigurationImpl;
import org.ops4j.pax.web.service.internal.DefaultPropertyResolver;
import org.ops4j.pax.web.service.internal.HttpServiceFactoryImpl;
import org.ops4j.pax.web.service.internal.HttpServiceProxy;
import org.ops4j.pax.web.service.internal.HttpServiceStarted;
import org.ops4j.pax.web.service.internal.JettyFactoryImpl;
import org.ops4j.pax.web.service.internal.ServerController;
import org.ops4j.pax.web.service.internal.ServerControllerImpl;
import org.ops4j.pax.web.service.internal.model.ServerModel;
import org.ops4j.pax.web.service.internal.util.JCLLogger;
import org.ops4j.util.property.DictionaryPropertyResolver;
import org.ops4j.util.property.FallbackPropertyResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.http.HttpService;

public class Activator
implements BundleActivator {
    private static final Log LOG = LogFactory.getLog(Activator.class);
    private final Lock m_lock = new ReentrantLock();
    private ServerController m_serverController;
    private ServerModel m_serverModel;

    public Activator() {
        ClassLoader backup = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(Activator.class.getClassLoader());
        JCLLogger.init();
        Thread.currentThread().setContextClassLoader(backup);
    }

    public void start(BundleContext bundleContext) throws Exception {
        LOG.info("Starting pax http service");
        this.createServerController();
        this.createManagedService(bundleContext);
        this.createHttpServiceFactory(bundleContext);
        LOG.info("Started pax http service");
    }

    public void stop(BundleContext bundleContext) throws Exception {
        LOG.info("Stopping pax http service");
        if (this.m_serverController != null) {
            this.m_serverController.stop();
            this.m_serverController = null;
        }
        this.m_serverModel = null;
        LOG.info("Stopped pax http service");
    }

    private void createHttpServiceFactory(BundleContext bundleContext) {
        bundleContext.registerService(new String[]{HttpService.class.getName(), WebContainer.class.getName()}, (Object)new HttpServiceFactoryImpl(){

            HttpService createService(Bundle bundle) {
                return new HttpServiceProxy(new HttpServiceStarted(bundle, Activator.this.m_serverController, Activator.this.m_serverModel));
            }
        }, new Hashtable());
    }

    private void createServerController() {
        this.m_serverModel = new ServerModel();
        this.m_serverController = new ServerControllerImpl(new JettyFactoryImpl(this.m_serverModel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createManagedService(final BundleContext bundleContext) {
        ManagedService managedService = new ManagedService(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void updated(Dictionary config) throws ConfigurationException {
                try {
                    Activator.this.m_lock.lock();
                    FallbackPropertyResolver resolver = config == null ? new BundleContextPropertyResolver(bundleContext, new DefaultPropertyResolver()) : new DictionaryPropertyResolver(config, new BundleContextPropertyResolver(bundleContext, new DefaultPropertyResolver()));
                    Activator.this.m_serverController.configure(new ConfigurationImpl(resolver));
                }
                finally {
                    Activator.this.m_lock.unlock();
                }
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", "org.ops4j.pax.web");
        bundleContext.registerService(ManagedService.class.getName(), (Object)managedService, props);
        try {
            this.m_lock.lock();
            if (!this.m_serverController.isConfigured()) {
                try {
                    managedService.updated(null);
                }
                catch (ConfigurationException ignore) {
                    LOG.error("Internal error. Cannot set initial configuration resolver.", ignore);
                }
            }
        }
        finally {
            this.m_lock.unlock();
        }
    }
}

