/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.io.File;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.internal.Configuration;
import org.ops4j.util.property.PropertyResolver;
import org.ops4j.util.property.PropertyStore;

public class ConfigurationImpl
extends PropertyStore
implements Configuration {
    private static final Log LOG = LogFactory.getLog(ConfigurationImpl.class);
    private final PropertyResolver m_propertyResolver;

    public ConfigurationImpl(PropertyResolver propertyResolver) {
        NullArgumentException.validateNotNull(propertyResolver, "Property resolver");
        this.m_propertyResolver = propertyResolver;
    }

    public Integer getHttpPort() {
        try {
            if (!this.contains("org.osgi.service.http.port")) {
                return this.set("org.osgi.service.http.port", Integer.valueOf(this.m_propertyResolver.get("org.osgi.service.http.port")));
            }
        }
        catch (Exception ignore) {
            LOG.warn("Reading configuration property org.osgi.service.http.port has failed");
        }
        return (Integer)this.get("org.osgi.service.http.port");
    }

    public Boolean isHttpEnabled() {
        try {
            if (!this.contains("org.osgi.service.http.enabled")) {
                return this.set("org.osgi.service.http.enabled", Boolean.valueOf(this.m_propertyResolver.get("org.osgi.service.http.enabled")));
            }
        }
        catch (Exception ignore) {
            LOG.warn("Reading configuration property org.osgi.service.http.enabled has failed");
        }
        return (Boolean)this.get("org.osgi.service.http.enabled");
    }

    public Integer getHttpSecurePort() {
        try {
            if (!this.contains("org.osgi.service.http.port.secure")) {
                return this.set("org.osgi.service.http.port.secure", Integer.valueOf(this.m_propertyResolver.get("org.osgi.service.http.port.secure")));
            }
        }
        catch (Exception ignore) {
            LOG.warn("Reading configuration property org.osgi.service.http.port.secure has failed");
        }
        return (Integer)this.get("org.osgi.service.http.port.secure");
    }

    public Boolean isHttpSecureEnabled() {
        try {
            if (!this.contains("org.osgi.service.http.secure.enabled")) {
                return this.set("org.osgi.service.http.secure.enabled", Boolean.valueOf(this.m_propertyResolver.get("org.osgi.service.http.secure.enabled")));
            }
        }
        catch (Exception ignore) {
            LOG.warn("Reading configuration property org.osgi.service.http.secure.enabled has failed");
        }
        return (Boolean)this.get("org.osgi.service.http.secure.enabled");
    }

    public String getSslKeystore() {
        try {
            if (!this.contains("org.ops4j.pax.web.ssl.keystore")) {
                return this.set("org.ops4j.pax.web.ssl.keystore", this.m_propertyResolver.get("org.ops4j.pax.web.ssl.keystore"));
            }
        }
        catch (Exception ignore) {
            LOG.warn("Reading configuration property org.ops4j.pax.web.ssl.keystore has failed");
        }
        return (String)this.get("org.ops4j.pax.web.ssl.keystore");
    }

    public String getSslPassword() {
        try {
            if (!this.contains("org.ops4j.pax.web.ssl.password")) {
                return this.set("org.ops4j.pax.web.ssl.password", this.m_propertyResolver.get("org.ops4j.pax.web.ssl.password"));
            }
        }
        catch (Exception ignore) {
            LOG.warn("Reading configuration property org.ops4j.pax.web.ssl.password has failed");
        }
        return (String)this.get("org.ops4j.pax.web.ssl.password");
    }

    public String getSslKeyPassword() {
        try {
            if (!this.contains("org.ops4j.pax.web.ssl.keypassword")) {
                return this.set("org.ops4j.pax.web.ssl.keypassword", this.m_propertyResolver.get("org.ops4j.pax.web.ssl.keypassword"));
            }
        }
        catch (Exception ignore) {
            LOG.warn("Reading configuration property org.ops4j.pax.web.ssl.keypassword has failed");
        }
        return (String)this.get("org.ops4j.pax.web.ssl.keypassword");
    }

    public File getTemporaryDirectory() {
        try {
            if (!this.contains("javax.servlet.context.tempdir")) {
                String tempDirPath = this.m_propertyResolver.get("javax.servlet.context.tempdir");
                File tempDir = tempDirPath.startsWith("file:") ? new File(new URI(tempDirPath)) : new File(tempDirPath);
                if (!tempDir.exists()) {
                    tempDir.mkdirs();
                }
                return this.set("javax.servlet.context.tempdir", tempDir);
            }
        }
        catch (Exception ignore) {
            LOG.warn("Reading configuration property javax.servlet.context.tempdir has failed");
        }
        return (File)this.get("javax.servlet.context.tempdir");
    }

    public Integer getSessionTimeout() {
        try {
            if (!this.contains("org.ops4j.pax.web.session.timeout")) {
                return this.set("org.ops4j.pax.web.session.timeout", Integer.valueOf(this.m_propertyResolver.get("org.ops4j.pax.web.session.timeout")));
            }
        }
        catch (Exception ignore) {
            LOG.warn("Reading configuration property org.ops4j.pax.web.session.timeout has failed");
        }
        return (Integer)this.get("org.ops4j.pax.web.session.timeout");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "http enabled=" + this.isHttpEnabled() + ",http port=" + this.getHttpPort() + ",http secure enabled=" + this.isHttpSecureEnabled() + ",http secure port=" + this.getHttpSecurePort() + ",ssl keystore=" + this.getSslKeystore() + ",session timeout=" + this.getSessionTimeout() + "}";
    }
}

