/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jetty.Request;
import org.ops4j.lang.NullArgumentException;

class HttpServiceRequestWrapper
extends HttpServletRequestWrapper {
    private static final Log LOG = LogFactory.getLog(HttpServiceRequestWrapper.class);
    private final Request m_request;

    HttpServiceRequestWrapper(HttpServletRequest request) {
        super(request);
        if (!(request instanceof Request)) {
            throw new IllegalArgumentException("Request must be a jetty specific request");
        }
        this.m_request = (Request)request;
    }

    public void setAttribute(String name, Object value) {
        if ("org.osgi.service.http.authentication.type".equals(name)) {
            this.handleAuthenticationType(value);
        } else if ("org.osgi.service.http.authentication.remote.user".equals(name)) {
            this.handleRemoteUser(value);
        }
        super.setAttribute(name, value);
    }

    private void handleAuthenticationType(Object authenticationType) {
        if (authenticationType != null && !(authenticationType instanceof String)) {
            String message = "Attribute org.osgi.service.http.authentication.type expected to be a String but was an [" + authenticationType.getClass() + "]";
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        this.m_request.setAuthType((String)authenticationType);
    }

    private void handleRemoteUser(Object remoteUser) {
        User userPrincipal = null;
        if (remoteUser != null) {
            if (!(remoteUser instanceof String)) {
                String message = "Attribute org.osgi.service.http.authentication.remote.user expected to be a String but was an [" + remoteUser.getClass() + "]";
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
            userPrincipal = new User((String)remoteUser);
        }
        this.m_request.setUserPrincipal(userPrincipal);
    }

    private static class User
    implements Principal {
        private final String m_name;

        public User(String name) {
            NullArgumentException.validateNotNull(name, "User name");
            this.m_name = name;
        }

        public String getName() {
            return this.m_name;
        }

        public int hashCode() {
            return this.m_name.hashCode();
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof User)) {
                return false;
            }
            User otherAsUser = (User)other;
            return this.m_name.equals(otherAsUser.m_name);
        }

        public String toString() {
            return this.m_name;
        }
    }
}

