/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jetty.servlet.ServletHandler;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.internal.HttpServiceRequestWrapper;
import org.ops4j.pax.web.service.internal.HttpServiceResponseWrapper;
import org.osgi.service.http.HttpContext;

class HttpServiceServletHandler
extends ServletHandler {
    private static final Log LOG = LogFactory.getLog(HttpServiceServletHandler.class);
    private final HttpContext m_httpContext;

    HttpServiceServletHandler(HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        this.m_httpContext = httpContext;
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatchMode) throws IOException, ServletException {
        LOG.debug("Request path info:    [" + request.getPathInfo() + "]");
        LOG.debug("Request context path: [" + request.getContextPath() + "]");
        HttpServiceRequestWrapper requestWrapper = new HttpServiceRequestWrapper(request);
        HttpServiceResponseWrapper responseWrapper = new HttpServiceResponseWrapper(response);
        if (this.m_httpContext.handleSecurity((HttpServletRequest)requestWrapper, (HttpServletResponse)responseWrapper)) {
            super.handle(target, request, response, dispatchMode);
        } else if (!responseWrapper.isCommitted()) {
            if (!responseWrapper.isStatusSet()) {
                responseWrapper.sendError(401);
            } else {
                responseWrapper.sendError(responseWrapper.getStatus());
            }
        }
    }
}

