/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import org.mortbay.jetty.Connector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.internal.JettyFactory;
import org.ops4j.pax.web.service.internal.JettyServer;
import org.ops4j.pax.web.service.internal.JettyServerImpl;
import org.ops4j.pax.web.service.internal.SocketConnectorWrapper;
import org.ops4j.pax.web.service.internal.model.ServerModel;

class JettyFactoryImpl
implements JettyFactory {
    private final ServerModel m_serverModel;

    JettyFactoryImpl(ServerModel serverModel) {
        NullArgumentException.validateNotNull(serverModel, "Service model");
        this.m_serverModel = serverModel;
    }

    public JettyServer createServer() {
        return new JettyServerImpl(this.m_serverModel);
    }

    public Connector createConnector(int port) {
        SocketConnectorWrapper connector = new SocketConnectorWrapper();
        connector.setPort(port);
        return connector;
    }

    public Connector createSecureConnector(int port, String sslKeystore, String sslPassword, String sslKeyPassword) {
        SslSocketConnector connector = new SslSocketConnector();
        connector.setPort(port);
        connector.setKeystore(sslKeystore);
        connector.setPassword(sslPassword);
        connector.setKeyPassword(sslKeyPassword);
        return connector;
    }
}

