/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.io.IOException;
import java.net.URL;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ops4j.lang.NullArgumentException;

class WelcomeFilesFilter
implements Filter {
    private final String[] m_welcomeFiles;
    private final boolean m_redirect;
    private FilterConfig m_filterConfig;

    WelcomeFilesFilter(String[] welcomeFiles, boolean redirect) {
        NullArgumentException.validateNotNull(welcomeFiles, "Welcome files");
        if (welcomeFiles.length == 0) {
            throw new NullArgumentException("Welcome files is be empty");
        }
        for (String welcomeFile : welcomeFiles) {
            if (welcomeFile == null || welcomeFile.trim().length() == 0) {
                throw new NullArgumentException("Welcome files entry is null or empty");
            }
            if (welcomeFile.startsWith("/")) {
                throw new NullArgumentException("Welcome files entry [" + welcomeFile + "] starts with '/'");
            }
            if (!welcomeFile.endsWith("/")) continue;
            throw new NullArgumentException("Welcome files entry [" + welcomeFile + "] ends with '/'");
        }
        this.m_welcomeFiles = welcomeFiles;
        this.m_redirect = redirect;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.m_filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String path;
        if (this.m_welcomeFiles.length > 0 && request instanceof HttpServletRequest && (path = ((HttpServletRequest)request).getServletPath()).endsWith("/")) {
            ServletContext servletContext = this.m_filterConfig.getServletContext();
            for (String welcomeFile : this.m_welcomeFiles) {
                String fullPath = path + welcomeFile;
                URL welcomeFileUrl = servletContext.getResource(path + welcomeFile);
                if (welcomeFileUrl == null) continue;
                if (this.m_redirect && response instanceof HttpServletResponse) {
                    ((HttpServletResponse)response).sendRedirect(fullPath.startsWith("/") ? fullPath.substring(1) : fullPath);
                    return;
                }
                RequestDispatcher requestDispatcher = request.getRequestDispatcher(fullPath);
                if (requestDispatcher == null) continue;
                requestDispatcher.forward(request, response);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

