/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxf.transport.http_osgi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Session;
import org.apache.cxf.transport.http.HTTPSession;
import org.apache.cxf.transport.https.SSLUtils;
import org.apache.cxf.transports.http.QueryHandler;
import org.apache.cxf.transports.http.QueryHandlerRegistry;
import org.apache.cxf.wsdl.http.AddressType;
import org.apache.servicemix.cxf.transport.http_osgi.OsgiDestination;
import org.apache.servicemix.cxf.transport.http_osgi.OsgiDestinationRegistry;

public class OsgiServlet
extends HttpServlet {
    private static final Logger LOG = LogUtils.getL7dLogger(OsgiServlet.class);
    private OsgiDestinationRegistry transport;
    private String lastBase = "";
    private boolean isHideServiceList;
    private boolean disableAddressUpdates;
    private String forcedBaseAddress;

    public OsgiServlet(OsgiDestinationRegistry transport) {
        this.transport = transport;
    }

    public void destroy() {
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.invoke(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.invoke(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.invoke(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.invoke(request, response);
    }

    public void setHideServiceList(boolean generate) {
        this.isHideServiceList = generate;
    }

    public void setDisableAddressUpdates(boolean noupdates) {
        this.disableAddressUpdates = noupdates;
    }

    public void setForcedBaseAddress(String s) {
        this.forcedBaseAddress = s;
    }

    private synchronized void updateDests(HttpServletRequest request) {
        if (this.disableAddressUpdates) {
            return;
        }
        String base = this.forcedBaseAddress == null ? this.getBaseURL(request) : this.forcedBaseAddress;
        Set<String> paths = this.transport.getDestinationsPaths();
        for (String path : paths) {
            OsgiDestination d2 = this.transport.getDestinationForPath(path);
            String ad = d2.getEndpointInfo().getAddress();
            if (!ad.equals(path) && !ad.equals(this.lastBase + path)) continue;
            d2.getEndpointInfo().setAddress(base + path);
            if (d2.getEndpointInfo().getExtensor(AddressType.class) == null) continue;
            ((AddressType)d2.getEndpointInfo().getExtensor(AddressType.class)).setLocation(base + path);
        }
        this.lastBase = base;
    }

    public void invoke(HttpServletRequest request, HttpServletResponse res) throws ServletException {
        try {
            EndpointInfo ei = new EndpointInfo();
            String address = request.getPathInfo() == null ? "" : request.getPathInfo();
            ei.setAddress(address);
            OsgiDestination d = this.transport.getDestinationForPath(ei.getAddress());
            if (d == null) {
                if (request.getRequestURI().endsWith("/services") || request.getRequestURI().endsWith("/services/") || StringUtils.isEmpty((String)request.getPathInfo()) || "/".equals(request.getPathInfo())) {
                    this.updateDests(request);
                    this.generateServiceList(request, res);
                } else {
                    d = this.checkRestfulRequest(request);
                    if (d == null || d.getMessageObserver() == null) {
                        LOG.warning("Can't find the the request for " + request.getRequestURL() + "'s Observer ");
                        this.generateNotFound(request, res);
                    } else {
                        this.updateDests(request);
                        this.invokeDestination(request, res, d);
                    }
                }
            } else {
                ei = d.getEndpointInfo();
                Bus bus = d.getBus();
                if (null != request.getQueryString() && request.getQueryString().length() > 0 && bus.getExtension(QueryHandlerRegistry.class) != null) {
                    String ctxUri = request.getPathInfo();
                    String baseUri = request.getRequestURL().toString() + "?" + request.getQueryString();
                    if ("GET".equals(request.getMethod())) {
                        this.updateDests(request);
                    }
                    for (QueryHandler qh : ((QueryHandlerRegistry)bus.getExtension(QueryHandlerRegistry.class)).getHandlers()) {
                        if (!qh.isRecognizedQuery(baseUri, ctxUri, ei)) continue;
                        res.setContentType(qh.getResponseContentType(baseUri, ctxUri));
                        ServletOutputStream out = res.getOutputStream();
                        try {
                            qh.writeResponse(baseUri, ctxUri, ei, (OutputStream)out);
                            out.flush();
                            return;
                        }
                        catch (Exception e) {
                            LOG.warning(qh.getClass().getName() + " Exception caught writing response: " + e.getMessage());
                        }
                    }
                }
                this.invokeDestination(request, res, d);
            }
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private OsgiDestination checkRestfulRequest(HttpServletRequest request) throws IOException {
        String address = request.getPathInfo() == null ? "" : request.getPathInfo();
        for (String path : this.transport.getDestinationsPaths()) {
            if (!address.startsWith(path)) continue;
            return this.transport.getDestinationForPath(path);
        }
        return null;
    }

    private void generateServiceList(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Collection<OsgiDestination> destinations = this.transport.getDestinations();
        response.setContentType("text/html");
        response.getWriter().write("<html><body>");
        if (!this.isHideServiceList) {
            if (destinations.size() > 0) {
                for (OsgiDestination sd : destinations) {
                    if (null == sd.getEndpointInfo().getName()) continue;
                    String address = sd.getEndpointInfo().getAddress();
                    response.getWriter().write("<p> <a href=\"" + address + "?wsdl\">");
                    response.getWriter().write(sd.getEndpointInfo().getName() + "</a> </p>");
                }
            } else {
                response.getWriter().write("No service was found.");
            }
        }
        response.getWriter().write("</body></html>");
    }

    private String getBaseURL(HttpServletRequest request) {
        String pathInfo;
        String reqPrefix = request.getRequestURL().toString();
        String string = pathInfo = request.getPathInfo() == null ? "" : request.getPathInfo();
        if (!"/".equals(pathInfo) || reqPrefix.endsWith("/")) {
            reqPrefix = reqPrefix.substring(0, reqPrefix.length() - pathInfo.length());
        }
        return reqPrefix;
    }

    protected void generateNotFound(HttpServletRequest request, HttpServletResponse res) throws IOException {
        res.setStatus(404);
        res.setContentType("text/html");
        res.getWriter().write("<html><body>No service was found.</body></html>");
    }

    public void invokeDestination(final HttpServletRequest request, HttpServletResponse response, OsgiDestination d) throws ServletException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Service http request on thread: " + Thread.currentThread());
        }
        try {
            String normalizedEncoding;
            MessageImpl inMessage = new MessageImpl();
            inMessage.setContent(InputStream.class, (Object)request.getInputStream());
            inMessage.put((Object)"HTTP.REQUEST", (Object)request);
            inMessage.put((Object)"HTTP.RESPONSE", (Object)response);
            inMessage.put((Object)"HTTP.CONTEXT", (Object)this.getServletContext());
            inMessage.put((Object)Message.HTTP_REQUEST_METHOD, (Object)request.getMethod());
            inMessage.put((Object)Message.PATH_INFO, (Object)request.getPathInfo());
            inMessage.put((Object)Message.QUERY_STRING, (Object)request.getQueryString());
            inMessage.put((Object)"Content-Type", (Object)request.getContentType());
            inMessage.put((Object)Message.BASE_PATH, (Object)d.getAddress().getAddress().getValue());
            inMessage.put(SecurityContext.class, (Object)new SecurityContext(){

                public Principal getUserPrincipal() {
                    return request.getUserPrincipal();
                }

                public boolean isUserInRole(String role) {
                    return request.isUserInRole(role);
                }
            });
            String enc = request.getCharacterEncoding();
            if (enc != null && enc.endsWith("\"")) {
                enc = enc.substring(0, enc.length() - 1);
            }
            if ((normalizedEncoding = HttpHeaderHelper.mapCharset((String)enc)) == null) {
                String m = new org.apache.cxf.common.i18n.Message("INVALID_ENCODING_MSG", LOG, new Object[]{enc}).toString();
                LOG.log(Level.WARNING, m);
                throw new IOException(m);
            }
            inMessage.put((Object)Message.ENCODING, (Object)normalizedEncoding);
            SSLUtils.propogateSecureSession((HttpServletRequest)request, (Message)inMessage);
            ExchangeImpl exchange = new ExchangeImpl();
            exchange.setInMessage((Message)inMessage);
            exchange.setSession((Session)new HTTPSession(request));
            d.doMessage(inMessage);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

