/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.war.deployer;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.kernel.filemonitor.DeploymentListener;
import org.apache.servicemix.war.deployer.IOUtils;

public class WarDeploymentListener
implements DeploymentListener {
    private static final Log LOGGER = LogFactory.getLog(WarDeploymentListener.class);

    public boolean canHandle(File artifact) {
        try {
            JarFile jar = new JarFile(artifact);
            JarEntry entry = jar.getJarEntry("WEB-INF/web.xml");
            if (entry == null) {
                return false;
            }
            Manifest m = jar.getManifest();
            return m.getMainAttributes().getValue(new Attributes.Name("Bundle-SymbolicName")) == null || m.getMainAttributes().getValue(new Attributes.Name("Bundle-Version")) == null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public File handle(File artifact, File tmpDir) {
        try {
            URL war = new URL("war:" + artifact.toURL().toString());
            File outFile = new File(tmpDir, artifact.getName());
            IOUtils.copyAndClose(war.openStream(), new FileOutputStream(outFile));
            return outFile;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to transform the WAR artifact into an OSGi bundle");
            return null;
        }
    }
}

