/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.osgi;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.osgi.Util;
import org.apache.geronimo.gshell.support.OsgiCommandSupport;
import org.osgi.framework.Bundle;

@CommandComponent(id="osgi:headers", description="Display headers")
public class Headers
extends OsgiCommandSupport {
    @Argument(required=false, multiValued=true, description="Bundles ids")
    List<Long> ids;

    protected Object doExecute() throws Exception {
        if (this.ids != null && !this.ids.isEmpty()) {
            for (long id : this.ids) {
                Bundle bundle = this.getBundleContext().getBundle(id);
                if (bundle != null) {
                    this.printHeaders(bundle);
                    continue;
                }
                this.io.err.println("Bundle ID " + id + " is invalid.");
            }
        } else {
            Bundle[] bundles = this.getBundleContext().getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                this.printHeaders(bundles[i]);
            }
        }
        return SUCCESS;
    }

    protected void printHeaders(Bundle bundle) throws Exception {
        String title = Util.getBundleName(bundle);
        this.io.out.println("\n" + title);
        this.io.out.println(Util.getUnderlineString(title));
        Dictionary dict = bundle.getHeaders();
        Enumeration keys = dict.keys();
        while (keys.hasMoreElements()) {
            String k = (String)keys.nextElement();
            Object v = dict.get(k);
            this.io.out.println(k + " = " + Util.getValueString(v));
        }
    }
}

