/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.internal;

import org.ops4j.pax.logging.internal.PaxLoggingServiceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class FrameworkHandler
implements BundleListener,
FrameworkListener,
ServiceListener {
    private PaxLoggingServiceImpl m_service;

    public FrameworkHandler(PaxLoggingServiceImpl service) {
        this.m_service = service;
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        String message;
        Bundle bundle = bundleEvent.getBundle();
        int type = bundleEvent.getType();
        switch (type) {
            case 1: {
                message = "BundleEvent INSTALLED";
                break;
            }
            case 2: {
                message = "BundleEvent STARTED";
                break;
            }
            case 4: {
                message = "BundleEvent STOPPED";
                break;
            }
            case 8: {
                message = "BundleEvent UPDATED";
                break;
            }
            case 16: {
                message = "BundleEvent UNINSTALLED";
                break;
            }
            case 32: {
                message = "BundleEvent RESOLVED";
                break;
            }
            case 64: {
                message = "BundleEvent UNRESOLVED";
                break;
            }
            case 128: {
                message = "BundleEvent STARTING";
                break;
            }
            case 256: {
                message = "BundleEvent STOPPING";
                break;
            }
            default: {
                message = "BundleEvent [unknown:" + type + "]";
            }
        }
        int level = 3;
        this.m_service.log(bundle, level, message, null);
    }

    public void frameworkEvent(FrameworkEvent frameworkEvent) {
        String message;
        int type = frameworkEvent.getType();
        switch (type) {
            case 2: {
                message = "FrameworkEvent ERROR";
                break;
            }
            case 32: {
                message = "FrameworkEvent INFO";
                break;
            }
            case 4: {
                message = "FrameworkEvent PACKAGES REFRESHED";
                break;
            }
            case 1: {
                message = "FrameworkEvent STARTED";
                break;
            }
            case 8: {
                message = "FrameworkEvent STARTLEVEL CHANGED";
                break;
            }
            case 16: {
                message = "FrameworkEvent WARNING";
                break;
            }
            default: {
                message = "FrameworkEvent [unknown:" + type + "]";
            }
        }
        Bundle bundle = frameworkEvent.getBundle();
        int level = 3;
        Throwable exception = frameworkEvent.getThrowable();
        this.m_service.log(bundle, level, message, exception);
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        String message;
        ServiceReference serviceRef = serviceEvent.getServiceReference();
        int type = serviceEvent.getType();
        switch (type) {
            case 2: {
                message = "ServiceEvent MODIFIED";
                break;
            }
            case 1: {
                message = "ServiceEvent REGISTERED";
                break;
            }
            case 4: {
                message = "ServiceEvent UNREGISTERING";
                break;
            }
            default: {
                message = "ServiceEvent [unknown:" + type + "]";
            }
        }
        int level = 3;
        this.m_service.log(serviceRef, level, message);
    }
}

