/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.eip.patterns;

import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.servicemix.common.util.MessageUtil;
import org.apache.servicemix.eip.EIPEndpoint;
import org.apache.servicemix.eip.support.ExchangeTarget;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ContentEnricher
extends EIPEndpoint {
    private ExchangeTarget target;
    private ExchangeTarget enricherTarget;
    private QName enricherElementName = new QName("enricher");
    private QName requestElementName = new QName("request");
    private QName resultElementName = new QName("result");

    public QName getEnricherElementName() {
        return this.enricherElementName;
    }

    public void setEnricherElementName(QName enricherElementName) {
        this.enricherElementName = enricherElementName;
    }

    public QName getRequestElementName() {
        return this.requestElementName;
    }

    public void setRequestElementName(QName requestElementName) {
        this.requestElementName = requestElementName;
    }

    public QName getResultElementName() {
        return this.resultElementName;
    }

    public void setResultElementName(QName resultElementName) {
        this.resultElementName = resultElementName;
    }

    protected void processAsync(MessageExchange exchange) throws Exception {
        throw new IllegalStateException();
    }

    protected void processSync(MessageExchange exchange) throws Exception {
        throw new IllegalStateException();
    }

    public void process(MessageExchange exchange) throws Exception {
        if (!(exchange instanceof InOnly) && !(exchange instanceof RobustInOnly)) {
            this.fail(exchange, new UnsupportedOperationException("Use an InOnly or RobustInOnly MEP"));
        }
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            return;
        }
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            return;
        }
        InOut enricherTargetME = this.getExchangeFactory().createInOutExchange();
        this.enricherTarget.configureTarget((MessageExchange)enricherTargetME, this.getContext());
        MessageUtil.transferInToIn((MessageExchange)exchange, (MessageExchange)enricherTargetME);
        this.sendSync((MessageExchange)enricherTargetME);
        if (enricherTargetME.getStatus() == ExchangeStatus.ERROR) {
            this.fail(exchange, enricherTargetME.getError());
            return;
        }
        Document document = this.combineToDOMDocument(exchange.getMessage("in"), enricherTargetME.getMessage("out"));
        this.done((MessageExchange)enricherTargetME);
        InOnly outExchange = this.getExchangeFactory().createInOnlyExchange();
        NormalizedMessage out = outExchange.createMessage();
        this.target.configureTarget((MessageExchange)outExchange, this.getContext());
        out.setContent((Source)new DOMSource(document));
        outExchange.setMessage(out, "in");
        this.sendSync((MessageExchange)outExchange);
        this.done(exchange);
    }

    private Document combineToDOMDocument(NormalizedMessage requestMessage, NormalizedMessage targetResultMessage) throws Exception, ParserConfigurationException {
        Node originalDocumentNode = this.getDOMNode(requestMessage.getContent());
        Node targetResultNode = this.getDOMNode(targetResultMessage.getContent());
        Document document = new SourceTransformer().createDocument();
        Element enricherElement = this.createChildElement(this.enricherElementName, document);
        Element requestElement = this.createChildElement(this.requestElementName, document);
        Node node = document.importNode(originalDocumentNode, true);
        requestElement.appendChild(node);
        enricherElement.appendChild(requestElement);
        document.appendChild(enricherElement);
        Element resultElement = this.createChildElement(this.resultElementName, document);
        Node node2 = document.importNode(targetResultNode, true);
        resultElement.appendChild(node2);
        enricherElement.appendChild(resultElement);
        return document;
    }

    private Element createChildElement(QName name, Document document) {
        Element elem = "".equals(name.getNamespaceURI()) ? document.createElement(name.getLocalPart()) : document.createElementNS(name.getNamespaceURI(), name.getPrefix() + ":" + name.getLocalPart());
        return elem;
    }

    private Node getDOMNode(Source source) throws Exception {
        SourceTransformer sourceTransformer = new SourceTransformer();
        Node node = sourceTransformer.toDOMNode(source);
        if (node.getNodeType() == 9) {
            node = ((Document)node).getDocumentElement();
        }
        return node;
    }

    public void setTarget(ExchangeTarget target) {
        this.target = target;
    }

    public void setEnricherTarget(ExchangeTarget enricherTarget) {
        this.enricherTarget = enricherTarget;
    }
}

