/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.eip.patterns;

import java.net.URI;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import javax.wsdl.Definition;
import org.apache.servicemix.common.util.MessageUtil;
import org.apache.servicemix.eip.EIPEndpoint;
import org.apache.servicemix.eip.support.ExchangeTarget;
import org.apache.servicemix.jbi.exception.FaultException;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;

public class Pipeline
extends EIPEndpoint {
    private static final String TRANSFORMER = "Pipeline.Transformer";
    private static final String CONSUMER_MEP = "Pipeline.ConsumerMEP";
    private ExchangeTarget transformer;
    private ExchangeTarget target;
    private ExchangeTarget faultsTarget;
    private boolean sendFaultsToTarget;
    private String correlationConsumer;
    private String correlationTransformer;
    private String correlationTarget;
    private boolean copyProperties;
    private boolean copyAttachments;

    public ExchangeTarget getTarget() {
        return this.target;
    }

    public void setTarget(ExchangeTarget target) {
        this.target = target;
    }

    public ExchangeTarget getFaultsTarget() {
        return this.faultsTarget;
    }

    public void setFaultsTarget(ExchangeTarget faultsTarget) {
        this.faultsTarget = faultsTarget;
    }

    public boolean isSendFaultsToTarget() {
        return this.sendFaultsToTarget;
    }

    public void setSendFaultsToTarget(boolean sendFaultsToTarget) {
        this.sendFaultsToTarget = sendFaultsToTarget;
    }

    public ExchangeTarget getTransformer() {
        return this.transformer;
    }

    public void setTransformer(ExchangeTarget transformer) {
        this.transformer = transformer;
    }

    public boolean isCopyProperties() {
        return this.copyProperties;
    }

    public void setCopyProperties(boolean copyProperties) {
        this.copyProperties = copyProperties;
    }

    public boolean isCopyAttachments() {
        return this.copyAttachments;
    }

    public void setCopyAttachments(boolean copyAttachments) {
        this.copyAttachments = copyAttachments;
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.target == null) {
            throw new IllegalArgumentException("target should be set to a valid ExchangeTarget");
        }
        if (this.transformer == null) {
            throw new IllegalArgumentException("transformer should be set to a valid ExchangeTarget");
        }
        this.correlationConsumer = "Pipeline.Consumer." + this.getService() + "." + this.getEndpoint();
        this.correlationTransformer = "Pipeline.Transformer." + this.getService() + "." + this.getEndpoint();
        this.correlationTarget = "Pipeline.Target." + this.getService() + "." + this.getEndpoint();
    }

    protected void processSync(MessageExchange exchange) throws Exception {
        if (!(exchange instanceof InOnly) && !(exchange instanceof RobustInOnly)) {
            this.fail(exchange, new UnsupportedOperationException("Use an InOnly or RobustInOnly MEP"));
            return;
        }
        InOut tme = this.getExchangeFactory().createInOutExchange();
        this.transformer.configureTarget((MessageExchange)tme, this.getContext());
        MessageUtil.transferInToIn((MessageExchange)exchange, (MessageExchange)tme);
        this.sendSync((MessageExchange)tme);
        if (tme.getStatus() == ExchangeStatus.DONE) {
            throw new IllegalStateException("Received a DONE status from the transformer");
        }
        if (tme.getStatus() == ExchangeStatus.ERROR) {
            this.fail(exchange, tme.getError());
        } else if (tme.getFault() != null) {
            this.processFault(exchange, tme);
        } else {
            if (tme.getOutMessage() == null) {
                throw new IllegalStateException("Exchange status is " + ExchangeStatus.ACTIVE + " but has no correlation set");
            }
            MessageExchange me = this.getExchangeFactory().createExchange(exchange.getPattern());
            this.target.configureTarget(me, this.getContext());
            MessageUtil.transferOutToIn((MessageExchange)tme, (MessageExchange)me);
            this.copyPropertiesAndAttachments(exchange.getMessage("in"), me.getMessage("in"));
            this.sendSync(me);
            this.done((MessageExchange)tme);
            if (me.getStatus() == ExchangeStatus.DONE) {
                this.done(exchange);
            } else if (me.getStatus() == ExchangeStatus.ERROR) {
                this.fail(exchange, me.getError());
            } else if (me.getFault() != null) {
                if (exchange instanceof InOnly) {
                    String fault = new SourceTransformer().contentToString((NormalizedMessage)me.getFault());
                    this.done(me);
                    this.fail(exchange, (Exception)new FaultException(fault, null, null));
                } else {
                    Fault fault = MessageUtil.copyFault((MessageExchange)me);
                    MessageUtil.transferToFault((Fault)fault, (MessageExchange)exchange);
                    this.done(me);
                    this.sendSync(exchange);
                }
            } else {
                throw new IllegalStateException("Exchange status is " + ExchangeStatus.ACTIVE + " but has no correlation set");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processFault(MessageExchange exchange, InOut tme) throws Exception {
        if (this.faultsTarget != null || this.sendFaultsToTarget) {
            MessageExchange me = this.getExchangeFactory().createExchange(exchange.getPattern());
            (this.faultsTarget != null ? this.faultsTarget : this.target).configureTarget(me, this.getContext());
            MessageUtil.transferToIn((NormalizedMessage)tme.getFault(), (MessageExchange)me);
            this.sendSync(me);
            this.done((MessageExchange)tme);
            if (me.getStatus() == ExchangeStatus.DONE) {
                this.done(exchange);
                return;
            } else if (me.getStatus() == ExchangeStatus.ERROR) {
                this.fail(exchange, me.getError());
                return;
            } else {
                if (me.getFault() == null) throw new IllegalStateException("Exchange status is " + ExchangeStatus.ACTIVE + " but has no correlation set");
                if (exchange instanceof InOnly) {
                    String fault = new SourceTransformer().contentToString((NormalizedMessage)me.getFault());
                    this.done(me);
                    this.fail(exchange, (Exception)new FaultException(fault, null, null));
                    return;
                } else {
                    Fault fault = MessageUtil.copyFault((MessageExchange)me);
                    MessageUtil.transferToFault((Fault)fault, (MessageExchange)exchange);
                    this.done(me);
                    this.sendSync(exchange);
                }
            }
            return;
        } else if (exchange instanceof InOnly) {
            String fault = new SourceTransformer().contentToString((NormalizedMessage)tme.getFault());
            this.done((MessageExchange)tme);
            this.fail(exchange, (Exception)new FaultException(fault, null, null));
            return;
        } else {
            Fault fault = MessageUtil.copyFault((MessageExchange)tme);
            MessageUtil.transferToFault((Fault)fault, (MessageExchange)exchange);
            this.done((MessageExchange)tme);
            this.sendSync(exchange);
        }
    }

    protected void processAsync(MessageExchange exchange) throws Exception {
        if (exchange.getRole() == MessageExchange.Role.PROVIDER) {
            this.processAsyncProvider(exchange);
        } else if (Boolean.TRUE.equals(exchange.getProperty(TRANSFORMER))) {
            this.processAsyncTransformerResponse(exchange);
        } else {
            this.processAsyncTargetResponse(exchange);
        }
    }

    private void processAsyncProvider(MessageExchange exchange) throws Exception {
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            String transformerId = (String)exchange.getProperty(this.correlationTransformer);
            String targetId = (String)exchange.getProperty(this.correlationTarget);
            if (transformerId == null && targetId == null) {
                throw new IllegalStateException("Exchange status is " + ExchangeStatus.DONE + " but has no correlation set");
            }
            MessageExchange me = (MessageExchange)this.store.load(targetId != null ? targetId : transformerId);
            this.done(me);
        } else if (exchange.getStatus() == ExchangeStatus.ERROR) {
            String transformerId = (String)exchange.getProperty(this.correlationTransformer);
            String targetId = (String)exchange.getProperty(this.correlationTarget);
            if (transformerId == null && targetId == null) {
                throw new IllegalStateException("Exchange status is " + ExchangeStatus.DONE + " but has no correlation set");
            }
            MessageExchange me = (MessageExchange)this.store.load(targetId != null ? targetId : transformerId);
            this.fail(me, exchange.getError());
        } else if (exchange.getProperty(this.correlationTransformer) == null) {
            if (!(exchange instanceof InOnly) && !(exchange instanceof RobustInOnly)) {
                this.fail(exchange, new UnsupportedOperationException("Use an InOnly or RobustInOnly MEP"));
                return;
            }
            InOut tme = this.getExchangeFactory().createInOutExchange();
            this.transformer.configureTarget((MessageExchange)tme, this.getContext());
            exchange.setProperty(this.correlationTransformer, (Object)tme.getExchangeId());
            tme.setProperty(this.correlationConsumer, (Object)exchange.getExchangeId());
            tme.setProperty(TRANSFORMER, (Object)Boolean.TRUE);
            tme.setProperty(CONSUMER_MEP, (Object)exchange.getPattern());
            this.store.store(exchange.getExchangeId(), (Object)exchange);
            MessageUtil.transferInToIn((MessageExchange)exchange, (MessageExchange)tme);
            this.send((MessageExchange)tme);
        } else {
            throw new IllegalStateException("Exchange status is " + ExchangeStatus.ACTIVE + " but has no correlation set");
        }
    }

    private void processAsyncTransformerResponse(MessageExchange exchange) throws Exception {
        String consumerId = (String)exchange.getProperty(this.correlationConsumer);
        if (consumerId == null) {
            throw new IllegalStateException(this.correlationConsumer + " property not found");
        }
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            throw new IllegalStateException("Received a DONE status from the transformer");
        }
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            MessageExchange me = (MessageExchange)this.store.load(consumerId);
            this.fail(me, exchange.getError());
        } else if (exchange.getFault() != null) {
            if (this.faultsTarget != null || this.sendFaultsToTarget) {
                URI mep = (URI)exchange.getProperty(CONSUMER_MEP);
                if (mep == null) {
                    throw new IllegalStateException("Exchange does not carry the consumer MEP");
                }
                MessageExchange me = this.getExchangeFactory().createExchange(mep);
                (this.faultsTarget != null ? this.faultsTarget : this.target).configureTarget(me, this.getContext());
                me.setProperty(this.correlationConsumer, (Object)consumerId);
                me.setProperty(this.correlationTransformer, (Object)exchange.getExchangeId());
                this.store.store(exchange.getExchangeId(), (Object)exchange);
                MessageUtil.transferToIn((NormalizedMessage)exchange.getFault(), (MessageExchange)me);
                this.send(me);
            } else {
                MessageExchange me = (MessageExchange)this.store.load(consumerId);
                if (me instanceof InOnly) {
                    String fault = new SourceTransformer().contentToString((NormalizedMessage)exchange.getFault());
                    this.fail(me, (Exception)new FaultException(fault, null, null));
                    this.done(exchange);
                } else {
                    this.store.store(exchange.getExchangeId(), (Object)exchange);
                    MessageUtil.transferFaultToFault((MessageExchange)exchange, (MessageExchange)me);
                    this.send(me);
                }
            }
        } else if (exchange.getMessage("out") != null) {
            MessageExchange cme;
            URI mep = (URI)exchange.getProperty(CONSUMER_MEP);
            if (mep == null) {
                throw new IllegalStateException("Exchange does not carry the consumer MEP");
            }
            MessageExchange me = this.getExchangeFactory().createExchange(mep);
            this.target.configureTarget(me, this.getContext());
            me.setProperty(this.correlationConsumer, (Object)consumerId);
            me.setProperty(this.correlationTransformer, (Object)exchange.getExchangeId());
            this.store.store(exchange.getExchangeId(), (Object)exchange);
            MessageUtil.transferOutToIn((MessageExchange)exchange, (MessageExchange)me);
            if ((this.copyProperties || this.copyAttachments) && (cme = (MessageExchange)this.store.load(consumerId)) != null) {
                NormalizedMessage cmeInMsg = cme.getMessage("in");
                NormalizedMessage meInMsg = me.getMessage("in");
                this.copyPropertiesAndAttachments(cmeInMsg, meInMsg);
                this.store.store(consumerId, (Object)cme);
            }
            this.send(me);
        } else {
            throw new IllegalStateException("Exchange status is " + ExchangeStatus.ACTIVE + " but has no Out nor Fault message");
        }
    }

    private void processAsyncTargetResponse(MessageExchange exchange) throws Exception {
        String consumerId = (String)exchange.getProperty(this.correlationConsumer);
        if (consumerId == null) {
            throw new IllegalStateException(this.correlationConsumer + " property not found");
        }
        String transformerId = (String)exchange.getProperty(this.correlationTransformer);
        if (transformerId == null) {
            throw new IllegalStateException(this.correlationTransformer + " property not found");
        }
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            MessageExchange tme = (MessageExchange)this.store.load(transformerId);
            this.done(tme);
            MessageExchange cme = (MessageExchange)this.store.load(consumerId);
            this.done(cme);
        } else if (exchange.getStatus() == ExchangeStatus.ERROR) {
            MessageExchange tme = (MessageExchange)this.store.load(transformerId);
            this.done(tme);
            MessageExchange cme = (MessageExchange)this.store.load(consumerId);
            this.fail(cme, exchange.getError());
        } else if (exchange.getFault() != null) {
            MessageExchange tme = (MessageExchange)this.store.load(transformerId);
            this.done(tme);
            this.store.store(exchange.getExchangeId(), (Object)exchange);
            MessageExchange cme = (MessageExchange)this.store.load(consumerId);
            cme.setProperty(this.correlationTarget, (Object)exchange.getExchangeId());
            MessageUtil.transferFaultToFault((MessageExchange)exchange, (MessageExchange)cme);
            this.send(cme);
        } else {
            throw new IllegalStateException("Exchange from target has a " + ExchangeStatus.ACTIVE + " status but has no Fault message");
        }
    }

    protected Definition getDefinitionFromWsdlExchangeTarget() {
        Definition rc = super.getDefinitionFromWsdlExchangeTarget();
        if (rc != null) {
            // empty if block
        }
        return rc;
    }

    private void copyPropertiesAndAttachments(NormalizedMessage from, NormalizedMessage to) throws MessagingException {
        if (this.copyProperties) {
            this.copyProperties(from, to);
        }
        if (this.copyAttachments) {
            this.copyAttachments(from, to);
        }
    }
}

