/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExchangeProperty<T> {
    private static final List<ExchangeProperty<?>> VALUES = new ArrayList();
    private static final Map<String, ExchangeProperty<?>> LITERAL_MAP = new HashMap();
    private static final Map<String, ExchangeProperty<?>> NAME_MAP = new HashMap();
    private final String literal;
    private final String name;
    private final Class<T> type;

    public ExchangeProperty(String literal, String name, Class<T> type) {
        this.literal = literal;
        this.name = name;
        this.type = type;
        ExchangeProperty.register(this);
    }

    public String literal() {
        return this.literal;
    }

    public String name() {
        return this.name;
    }

    public Class<T> type() {
        return this.type;
    }

    public T get(Exchange exchange) {
        return exchange.getProperty(this.name, this.type);
    }

    public static ExchangeProperty<?> get(String literal) {
        return LITERAL_MAP.get(literal);
    }

    public static ExchangeProperty<?> getByName(String name) {
        return NAME_MAP.get(name);
    }

    public T set(Exchange exchange, T value) {
        T oldValue = this.get(exchange);
        exchange.setProperty(this.name, value);
        return oldValue;
    }

    public T remove(Exchange exchange) {
        T oldValue = this.get(exchange);
        exchange.removeProperty(this.name);
        return oldValue;
    }

    public String toString() {
        return this.type().getCanonicalName() + " " + this.name + " (" + this.literal() + ")";
    }

    public static synchronized void register(ExchangeProperty<?> property) {
        ExchangeProperty<?> existingProperty = LITERAL_MAP.get(property.literal());
        if (existingProperty != null && existingProperty != property) {
            throw new RuntimeCamelException("An Exchange Property '" + property.literal() + "' has already been registered; its traits are: " + existingProperty.toString());
        }
        VALUES.add(property);
        LITERAL_MAP.put(property.literal(), property);
        NAME_MAP.put(property.name(), property);
    }

    public static synchronized void deregister(ExchangeProperty<?> property) {
        if (property != null) {
            VALUES.remove(property);
            LITERAL_MAP.remove(property.literal());
            NAME_MAP.put(property.name(), property);
        }
    }

    public static synchronized void deregister(String literal) {
        ExchangeProperty<?> property = LITERAL_MAP.get(literal);
        if (property != null) {
            VALUES.remove(property);
            LITERAL_MAP.remove(property.literal());
            NAME_MAP.put(property.name(), property);
        }
    }

    public static synchronized ExchangeProperty<?>[] values() {
        return VALUES.toArray(new ExchangeProperty[0]);
    }
}

