/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.model.ProcessorType;
import org.apache.camel.model.dataformat.ArtixDSContentType;
import org.apache.camel.model.dataformat.ArtixDSDataFormat;
import org.apache.camel.model.dataformat.CsvDataFormat;
import org.apache.camel.model.dataformat.DataFormatType;
import org.apache.camel.model.dataformat.HL7DataFormat;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.apache.camel.model.dataformat.SerializationDataFormat;
import org.apache.camel.model.dataformat.StringDataFormat;
import org.apache.camel.model.dataformat.XMLBeansDataFormat;
import org.apache.camel.model.dataformat.XStreamDataFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataFormatClause<T extends ProcessorType> {
    private final T processorType;
    private final Operation operation;

    public DataFormatClause(T processorType, Operation operation) {
        this.processorType = processorType;
        this.operation = operation;
    }

    public T artixDS() {
        return this.dataFormat(new ArtixDSDataFormat());
    }

    public T artixDS(Class<?> dataObjectType) {
        return this.dataFormat(new ArtixDSDataFormat(dataObjectType));
    }

    public T artixDS(Class<?> elementType, ArtixDSContentType contentType) {
        return this.dataFormat(new ArtixDSDataFormat(elementType, contentType));
    }

    public T artixDS(ArtixDSContentType contentType) {
        return this.dataFormat(new ArtixDSDataFormat(contentType));
    }

    public T csv() {
        return this.dataFormat(new CsvDataFormat());
    }

    public T hl7() {
        return this.dataFormat(new HL7DataFormat());
    }

    public T jaxb() {
        return this.dataFormat(new JaxbDataFormat());
    }

    public T jaxb(boolean prettyPrint) {
        return this.dataFormat(new JaxbDataFormat(prettyPrint));
    }

    public T serialization() {
        return this.dataFormat(new SerializationDataFormat());
    }

    public T string() {
        return this.string(null);
    }

    public T string(String charset) {
        StringDataFormat sdf = new StringDataFormat();
        sdf.setCharset(charset);
        return this.dataFormat(sdf);
    }

    public T xmlBeans() {
        return this.dataFormat(new XMLBeansDataFormat());
    }

    public T xstream() {
        return this.dataFormat(new XStreamDataFormat());
    }

    private T dataFormat(DataFormatType dataFormatType) {
        switch (this.operation) {
            case Unmarshal: {
                return (T)((ProcessorType)this.processorType).unmarshal(dataFormatType);
            }
            case Marshal: {
                return (T)((ProcessorType)this.processorType).marshal(dataFormatType);
            }
        }
        throw new IllegalArgumentException("Unknown DataFormat operation: " + (Object)((Object)this.operation));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        Marshal,
        Unmarshal;

    }
}

