/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderSupport;
import org.apache.camel.processor.Logger;
import org.apache.camel.processor.LoggingErrorHandler;
import org.apache.camel.processor.LoggingLevel;
import org.apache.camel.spi.RouteContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoggingErrorHandlerBuilder
extends ErrorHandlerBuilderSupport {
    private Log log = LogFactory.getLog(Logger.class);
    private LoggingLevel level = LoggingLevel.INFO;

    public LoggingErrorHandlerBuilder() {
    }

    public LoggingErrorHandlerBuilder(Log log) {
        this.log = log;
    }

    public LoggingErrorHandlerBuilder(Log log, LoggingLevel level) {
        this.log = log;
        this.level = level;
    }

    public ErrorHandlerBuilder copy() {
        LoggingErrorHandlerBuilder answer = new LoggingErrorHandlerBuilder();
        answer.setLog(this.getLog());
        answer.setLevel(this.getLevel());
        return answer;
    }

    public Processor createErrorHandler(RouteContext routeContext, Processor processor) {
        LoggingErrorHandler handler = new LoggingErrorHandler(processor, this.log, this.level);
        this.configure(handler);
        return handler;
    }

    public LoggingLevel getLevel() {
        return this.level;
    }

    public void setLevel(LoggingLevel level) {
        this.level = level;
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }
}

