/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Pattern;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.component.bean.ParameterInfo;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInfo {
    private static final transient Log LOG = LogFactory.getLog(MethodInfo.class);
    private Class type;
    private Method method;
    private final List<ParameterInfo> parameters;
    private final List<ParameterInfo> bodyParameters;
    private final boolean hasCustomAnnotation;
    private Expression parametersExpression;
    private ExchangePattern pattern = ExchangePattern.InOut;

    public MethodInfo(Class type, Method method, List<ParameterInfo> parameters, List<ParameterInfo> bodyParameters, boolean hasCustomAnnotation) {
        this.type = type;
        this.method = method;
        this.parameters = parameters;
        this.bodyParameters = bodyParameters;
        this.hasCustomAnnotation = hasCustomAnnotation;
        this.parametersExpression = this.createParametersExpression();
        Pattern oneway = this.findOneWayAnnotation(method);
        if (oneway != null) {
            this.pattern = oneway.value();
        }
    }

    public String toString() {
        return this.method.toString();
    }

    public MethodInvocation createMethodInvocation(final Object pojo, final Exchange messageExchange) {
        final Object[] arguments = (Object[])this.parametersExpression.evaluate(messageExchange);
        return new MethodInvocation(){

            public Method getMethod() {
                return MethodInfo.this.method;
            }

            public Object[] getArguments() {
                return arguments;
            }

            public Object proceed() throws Throwable {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(">>>> invoking: " + MethodInfo.this.method + " on bean: " + pojo + " with arguments: " + ObjectHelper.asString(arguments) + " for exchange: " + messageExchange));
                }
                return MethodInfo.this.invoke(MethodInfo.this.method, pojo, arguments, messageExchange);
            }

            public Object getThis() {
                return pojo;
            }

            public AccessibleObject getStaticPart() {
                return MethodInfo.this.method;
            }
        };
    }

    public Class getType() {
        return this.type;
    }

    public Method getMethod() {
        return this.method;
    }

    public ExchangePattern getPattern() {
        return this.pattern;
    }

    public Expression getParametersExpression() {
        return this.parametersExpression;
    }

    public List<ParameterInfo> getBodyParameters() {
        return this.bodyParameters;
    }

    public Class getBodyParameterType() {
        ParameterInfo parameterInfo = this.bodyParameters.get(0);
        return parameterInfo.getType();
    }

    public boolean bodyParameterMatches(Class bodyType) {
        Class actualType = this.getBodyParameterType();
        return actualType != null && ObjectHelper.isAssignableFrom(bodyType, actualType);
    }

    public List<ParameterInfo> getParameters() {
        return this.parameters;
    }

    public boolean hasBodyParameter() {
        return !this.bodyParameters.isEmpty();
    }

    public boolean isHasCustomAnnotation() {
        return this.hasCustomAnnotation;
    }

    public boolean isReturnTypeVoid() {
        return this.method.getReturnType().getName().equals("void");
    }

    protected Object invoke(Method mth, Object pojo, Object[] arguments, Exchange exchange) throws IllegalAccessException, InvocationTargetException {
        return mth.invoke(pojo, arguments);
    }

    protected Expression createParametersExpression() {
        final int size = this.parameters.size();
        final Expression[] expressions = new Expression[size];
        for (int i = 0; i < size; ++i) {
            Expression parameterExpression;
            expressions[i] = parameterExpression = this.parameters.get(i).getExpression();
        }
        return new Expression<Exchange>(){

            @Override
            public Object evaluate(Exchange exchange) {
                Object[] answer = new Object[size];
                Object body = exchange.getIn().getBody();
                boolean multiParameterArray = false;
                if (exchange.getIn().getHeader("org.apache.camel.MultiParameterArray") != null) {
                    multiParameterArray = exchange.getIn().getHeader("org.apache.camel.MultiParameterArray", Boolean.class);
                }
                for (int i = 0; i < size; ++i) {
                    Object value = null;
                    value = multiParameterArray ? ((Object[])body)[i] : expressions[i].evaluate(exchange);
                    Class expectedType = ((ParameterInfo)MethodInfo.this.parameters.get(i)).getType();
                    answer[i] = value = ExchangeHelper.convertToType(exchange, expectedType, value);
                }
                return answer;
            }

            public String toString() {
                return "ParametersExpression: " + Arrays.asList(expressions);
            }
        };
    }

    protected Pattern findOneWayAnnotation(Method method) {
        Pattern answer = this.getPatternAnnotation(method);
        if (answer == null) {
            Class<?>[] interfaces;
            Class<?> type = method.getDeclaringClass();
            ArrayList typesToSearch = new ArrayList();
            this.addTypeAndSuperTypes(type, typesToSearch);
            for (Class<?> anInterface : interfaces = type.getInterfaces()) {
                this.addTypeAndSuperTypes(anInterface, typesToSearch);
            }
            answer = this.findOneWayAnnotationOnMethod(typesToSearch, method);
            if (answer == null) {
                answer = this.findOneWayAnnotation(typesToSearch);
            }
        }
        return answer;
    }

    protected Pattern getPatternAnnotation(AnnotatedElement annotatedElement) {
        return this.getPatternAnnotation(annotatedElement, 2);
    }

    protected Pattern getPatternAnnotation(AnnotatedElement annotatedElement, int depth) {
        Pattern answer = annotatedElement.getAnnotation(Pattern.class);
        int nextDepth = depth - 1;
        if (nextDepth > 0) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = annotatedElement.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (annotation instanceof Pattern || annotationType.equals(annotatedElement)) continue;
                Pattern another = this.getPatternAnnotation(annotationType, nextDepth);
                if (this.pattern == null) continue;
                if (answer == null) {
                    answer = another;
                    continue;
                }
                LOG.warn((Object)("Duplicate pattern annotation: " + another + " found on annotation: " + annotation + " which will be ignored"));
            }
        }
        return answer;
    }

    protected void addTypeAndSuperTypes(Class<?> type, List<Class<?>> result) {
        for (Class<?> t = type; t != null && t != Object.class; t = t.getSuperclass()) {
            result.add(t);
        }
    }

    protected Pattern findOneWayAnnotationOnMethod(List<Class<?>> classes, Method method) {
        for (Class<?> type : classes) {
            try {
                Method definedMethod = type.getMethod(method.getName(), method.getParameterTypes());
                Pattern answer = this.getPatternAnnotation(definedMethod);
                if (answer == null) continue;
                return answer;
            }
            catch (NoSuchMethodException e) {
            }
        }
        return null;
    }

    protected Pattern findOneWayAnnotation(List<Class<?>> classes) {
        for (Class<?> type : classes) {
            Pattern answer = this.getPatternAnnotation(type);
            if (answer == null) continue;
            return answer;
        }
        return null;
    }
}

