/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.FileExchange;
import org.apache.camel.component.file.FileProcessStrategy;
import org.apache.camel.component.file.strategy.DefaultFileRenamer;
import org.apache.camel.component.file.strategy.FileRenamer;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class FileProcessStrategySupport
implements FileProcessStrategy {
    private static final transient Log LOG = LogFactory.getLog(FileProcessStrategySupport.class);
    private boolean lockFile;
    private FileRenamer lockFileRenamer;

    protected FileProcessStrategySupport() {
        this(true);
    }

    protected FileProcessStrategySupport(boolean lockFile) {
        this(lockFile, new DefaultFileRenamer(null, ".camelLock"));
    }

    protected FileProcessStrategySupport(boolean lockFile, FileRenamer lockFileRenamer) {
        this.lockFile = lockFile;
        this.lockFileRenamer = lockFileRenamer;
    }

    public boolean begin(FileEndpoint endpoint, FileExchange exchange, File file) throws Exception {
        if (this.isLockFile()) {
            FileChannel channel;
            FileLock lock;
            File newFile = this.lockFileRenamer.renameFile(exchange, file);
            String lockFileName = newFile.getAbsolutePath();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Locking the file: " + file + " using the lock file name: " + lockFileName));
            }
            if ((lock = (channel = new RandomAccessFile(lockFileName, "rw").getChannel()).lock()) != null) {
                exchange.setProperty("org.apache.camel.fileChannel", channel);
                exchange.setProperty("org.apache.camel.file.lock", lock);
                exchange.setProperty("org.apache.camel.file.lock.name", lockFileName);
                return true;
            }
            return false;
        }
        return true;
    }

    public void commit(FileEndpoint endpoint, FileExchange exchange, File file) throws Exception {
        this.unlockFile(endpoint, exchange, file);
    }

    public void rollback(FileEndpoint endpoint, FileExchange exchange, File file) {
        try {
            this.unlockFile(endpoint, exchange, file);
        }
        catch (Exception e) {
            LOG.info((Object)("Unable to unlock file: " + file + ": " + e.getMessage()), (Throwable)e);
        }
    }

    public boolean isLockFile() {
        return this.lockFile;
    }

    public void setLockFile(boolean lockFile) {
        this.lockFile = lockFile;
    }

    public FileRenamer getLockFileRenamer() {
        return this.lockFileRenamer;
    }

    public void setLockFileRenamer(FileRenamer lockFileRenamer) {
        this.lockFileRenamer = lockFileRenamer;
    }

    protected void unlockFile(FileEndpoint endpoint, FileExchange exchange, File file) throws Exception {
        if (this.isLockFile()) {
            Channel channel = ExchangeHelper.getMandatoryProperty(exchange, "org.apache.camel.fileChannel", Channel.class);
            String lockfile = ExchangeHelper.getMandatoryProperty(exchange, "org.apache.camel.file.lock.name", String.class);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Unlocking file: " + file));
            }
            channel.close();
            File lock = new File(lockfile);
            lock.delete();
        }
    }
}

