/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.converter.stream.StreamCache;
import org.apache.camel.processor.interceptor.ExchangeFormatter;
import org.apache.camel.util.ObjectHelper;

public class LogFormatter
implements ExchangeFormatter {
    private boolean showExchangeId;
    private boolean showProperties;
    private boolean showHeaders;
    private boolean showBodyType = true;
    private boolean showBody = true;
    private boolean showOut;
    private boolean showAll;
    private boolean multiline;

    public Object format(Exchange exchange) {
        Message in = exchange.getIn();
        StringBuilder sb = new StringBuilder("");
        if (this.showAll || this.showExchangeId) {
            if (this.multiline) {
                sb.append('\n');
            }
            sb.append(", Id:").append(exchange.getExchangeId());
        }
        if (this.showAll || this.showProperties) {
            if (this.multiline) {
                sb.append('\n');
            }
            sb.append(", Properties:").append(exchange.getProperties());
        }
        if (this.showAll || this.showHeaders) {
            if (this.multiline) {
                sb.append('\n');
            }
            sb.append(", Headers:").append(in.getHeaders());
        }
        if (this.showAll || this.showBodyType) {
            if (this.multiline) {
                sb.append('\n');
            }
            sb.append(", BodyType:").append(this.getBodyTypeAsString(in));
        }
        if (this.showAll || this.showBody) {
            if (this.multiline) {
                sb.append('\n');
            }
            sb.append(", Body:").append(this.getBodyAsString(in));
        }
        Message out = exchange.getOut(false);
        if (this.showAll || this.showOut) {
            if (out != null) {
                if (this.showAll || this.showHeaders) {
                    if (this.multiline) {
                        sb.append('\n');
                    }
                    sb.append(", OutHeaders:").append(out.getHeaders());
                }
                if (this.showAll || this.showBodyType) {
                    if (this.multiline) {
                        sb.append('\n');
                    }
                    sb.append(", OutBodyType:").append(this.getBodyTypeAsString(out));
                }
                if (this.showAll || this.showBody) {
                    if (this.multiline) {
                        sb.append('\n');
                    }
                    sb.append(", OutBody:").append(this.getBodyAsString(out));
                }
            } else {
                if (this.multiline) {
                    sb.append('\n');
                }
                sb.append(", Out: null");
            }
        }
        return "Exchange[" + (this.multiline ? sb.append(']').toString() : sb.toString().substring(2) + "]");
    }

    public boolean isShowExchangeId() {
        return this.showExchangeId;
    }

    public void setShowExchangeId(boolean showExchangeId) {
        this.showExchangeId = showExchangeId;
    }

    public boolean isShowProperties() {
        return this.showProperties;
    }

    public void setShowProperties(boolean showProperties) {
        this.showProperties = showProperties;
    }

    public boolean isShowHeaders() {
        return this.showHeaders;
    }

    public void setShowHeaders(boolean showHeaders) {
        this.showHeaders = showHeaders;
    }

    public boolean isShowBodyType() {
        return this.showBodyType;
    }

    public void setShowBodyType(boolean showBodyType) {
        this.showBodyType = showBodyType;
    }

    public boolean isShowBody() {
        return this.showBody;
    }

    public void setShowBody(boolean showBody) {
        this.showBody = showBody;
    }

    public boolean isShowOut() {
        return this.showOut;
    }

    public void setShowOut(boolean showOut) {
        this.showOut = showOut;
    }

    public boolean isShowAll() {
        return this.showAll;
    }

    public void setShowAll(boolean showAll) {
        this.showAll = showAll;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    protected Object getBodyAsString(Message message) {
        Object answer;
        StreamCache newBody = message.getBody(StreamCache.class);
        if (newBody != null) {
            message.setBody(newBody);
        }
        if ((answer = message.getBody(String.class)) == null) {
            answer = message.getBody();
        }
        if (newBody != null) {
            newBody.reset();
        }
        return answer;
    }

    protected Object getBodyTypeAsString(Message message) {
        String answer = ObjectHelper.classCanonicalName(message.getBody());
        if (answer != null && answer.startsWith("java.lang.")) {
            return answer.substring(10);
        }
        return answer;
    }
}

