/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.seda.CollectionProducer;
import org.apache.camel.component.seda.SedaComponent;
import org.apache.camel.component.seda.SedaConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.BrowsableEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SedaEndpoint
extends DefaultEndpoint<Exchange>
implements BrowsableEndpoint<Exchange> {
    private BlockingQueue<Exchange> queue;

    public SedaEndpoint(String endpointUri, Component component, BlockingQueue<Exchange> queue) {
        super(endpointUri, component);
        this.queue = queue;
    }

    public SedaEndpoint(String uri, SedaComponent component, Map parameters) {
        this(uri, (Component)component, component.createQueue(uri, parameters));
    }

    public SedaEndpoint(String endpointUri, BlockingQueue<Exchange> queue) {
        super(endpointUri);
        this.queue = queue;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new CollectionProducer(this, this.getQueue());
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        return new SedaConsumer(this, processor);
    }

    public BlockingQueue<Exchange> getQueue() {
        return this.queue;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public List<Exchange> getExchanges() {
        return new ArrayList<Exchange>(this.getQueue());
    }
}

