/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultComponent<E extends Exchange>
extends ServiceSupport
implements Component<E> {
    private static final transient Log LOG = LogFactory.getLog(DefaultComponent.class);
    private int defaultThreadPoolSize = 5;
    private CamelContext camelContext;
    private ScheduledExecutorService executorService;

    public DefaultComponent() {
    }

    public DefaultComponent(CamelContext context) {
        this.camelContext = context;
    }

    @Override
    public Endpoint<E> createEndpoint(String uri) throws Exception {
        Endpoint<E> endpoint;
        int idx;
        ObjectHelper.notNull(this.getCamelContext(), "camelContext");
        URI u = new URI(UnsafeUriCharactersEncoder.encode(uri));
        String path = u.getSchemeSpecificPart();
        if (path.startsWith("//")) {
            path = path.substring(2);
        }
        if ((idx = path.indexOf(63)) > 0) {
            path = path.substring(0, idx);
        }
        Map parameters = URISupport.parseParameters(u);
        this.validateURI(uri, path, parameters);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating endpoint uri=[" + uri + "], path=[" + path + "], parameters=[" + parameters + "]"));
        }
        if ((endpoint = this.createEndpoint(uri, path, parameters)) == null) {
            return null;
        }
        if (parameters != null) {
            endpoint.configureProperties(parameters);
            if (this.useIntrospectionOnEndpoint()) {
                this.setProperties(endpoint, parameters);
            }
            if (!endpoint.isLenientProperties() && parameters.size() > 0) {
                throw new ResolveEndpointFailedException(uri, "There are " + parameters.size() + " parameters that couldn't be set on the endpoint." + " Check the uri if the parameters are spelt correctly and that they are properties of the endpoint." + " Unknown parameters=[" + parameters + "]");
            }
        }
        return endpoint;
    }

    protected void validateURI(String uri, String path, Map parameters) throws ResolveEndpointFailedException {
        if (uri.contains("&") && !uri.contains("?")) {
            throw new ResolveEndpointFailedException(uri, "Invalid uri syntax: no ? marker however the uri has & parameter separators. Check the uri if its missing a ? marker.");
        }
        if (uri.contains("&&")) {
            throw new ResolveEndpointFailedException(uri, "Invalid uri syntax: Double && marker found. Check the uri and remove the duplicate & marker.");
        }
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext context) {
        this.camelContext = context;
    }

    public ScheduledExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = this.createExecutorService();
        }
        return this.executorService;
    }

    public void setExecutorService(ScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    protected ScheduledExecutorService createExecutorService() {
        return new ScheduledThreadPoolExecutor(this.defaultThreadPoolSize, new ThreadFactory(){
            int counter;

            public synchronized Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName("Thread: " + ++this.counter + " " + DefaultComponent.this.toString());
                return thread;
            }
        });
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    protected abstract Endpoint<E> createEndpoint(String var1, String var2, Map var3) throws Exception;

    protected void setProperties(Object bean, Map parameters) throws Exception {
        IntrospectionSupport.setProperties(this.getCamelContext().getTypeConverter(), bean, parameters);
    }

    protected boolean useIntrospectionOnEndpoint() {
        return true;
    }

    public <T> T convertTo(Class<T> type, Object value) {
        return CamelContextHelper.convertTo(this.getCamelContext(), type, value);
    }

    public <T> T mandatoryConvertTo(Class<T> type, Object value) {
        return CamelContextHelper.mandatoryConvertTo(this.getCamelContext(), type, value);
    }

    public <T> T newInstance(Class<T> beanType) {
        return this.getCamelContext().getInjector().newInstance(beanType);
    }

    public Object lookup(String name) {
        return this.getCamelContext().getRegistry().lookup(name);
    }

    public <T> T lookup(String name, Class<T> beanType) {
        return this.getCamelContext().getRegistry().lookup(name, beanType);
    }

    public Object mandatoryLookup(String name) {
        return CamelContextHelper.mandatoryLookup(this.getCamelContext(), name);
    }

    public <T> T mandatoryLookup(String name, Class<T> beanType) {
        return CamelContextHelper.mandatoryLookup(this.getCamelContext(), name, beanType);
    }

    public <T> T getAndRemoveParameter(Map parameters, String key, Class<T> type) {
        return this.getAndRemoveParameter(parameters, key, type, null);
    }

    public <T> T getAndRemoveParameter(Map parameters, String key, Class<T> type, T defaultValue) {
        Object value = parameters.remove(key);
        if (value == null) {
            value = defaultValue;
        }
        if (value == null) {
            return null;
        }
        return this.convertTo(type, value);
    }
}

