/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultPollingEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.impl.ProcessorPollingConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessorEndpoint
extends DefaultPollingEndpoint<Exchange> {
    private Processor processor;

    protected ProcessorEndpoint() {
    }

    protected ProcessorEndpoint(String endpointUri) {
        super(endpointUri);
    }

    public ProcessorEndpoint(String endpointUri, CamelContext context, Processor processor) {
        super(endpointUri, context);
        this.processor = processor;
    }

    public ProcessorEndpoint(String endpointUri, Component component, Processor processor) {
        super(endpointUri, component);
        this.processor = processor;
    }

    public ProcessorEndpoint(String endpointUri, Processor processor) {
        super(endpointUri);
        this.processor = processor;
    }

    protected ProcessorEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    @Override
    public Producer<Exchange> createProducer() throws Exception {
        return new DefaultProducer<Exchange>((Endpoint)this){

            @Override
            public void process(Exchange exchange) throws Exception {
                ProcessorEndpoint.this.onExchange(exchange);
            }
        };
    }

    @Override
    public PollingConsumer<Exchange> createPollingConsumer() throws Exception {
        return new ProcessorPollingConsumer(this, this.getProcessor());
    }

    public Processor getProcessor() throws Exception {
        if (this.processor == null) {
            this.processor = this.createProcessor();
        }
        return this.processor;
    }

    protected Processor createProcessor() throws Exception {
        return new Processor(){

            public void process(Exchange exchange) throws Exception {
                ProcessorEndpoint.this.onExchange(exchange);
            }
        };
    }

    protected void onExchange(Exchange exchange) throws Exception {
        this.getProcessor().process(exchange);
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

